/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaguya.ash_of_sin_soul_like_boss_battle.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class SoulLikeBossBattleConfig {
    public static final ForgeConfigSpec SOUL_LIKE_BOSS_BATTLE_CONFIG;
    public static ForgeConfigSpec.BooleanValue SOUL_LIKE_BOSS_BATTLE_ON;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> SOUL_LIKE_BOSS_BATTLE_ENTITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BOSS_BATTLE_DISTANCE;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYER_GAMEMODE;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> IRON_GOLEM;
    public static ForgeConfigSpec.ConfigValue<Boolean> ANTI_IRON_GOLEM;
    public final Path configPath = FMLPaths.CONFIGDIR.get().resolve("ash_of_sin/soul_like_boss_battle.toml");

    public SoulLikeBossBattleConfig() {
        this.loadConfig();
    }

    public void loadConfig() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create default soul like boss battle config.", e);
            }
        }
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        fileConfig.load();
        SOUL_LIKE_BOSS_BATTLE_CONFIG.setConfig((CommentedConfig)fileConfig);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SOUL_LIKE_BOSS_BATTLE_ON = builder.comment("Soul Like Boss Battle On").comment("Enable Soul Like Boss Battle").define("Soul Like Boss Battle On", true);
        SOUL_LIKE_BOSS_BATTLE_ENTITY = builder.comment("Soul Like Boss Battle Entity").comment("Soul Like Boss Battle Entity id.").defineList("Soul Like Boss Battle Entity", () -> new ArrayList<String>(Arrays.asList("minecraft:wither", "minecraft:ender_dragon", "cataclysm:ancient_remnant", "cataclysm:the_leviathan", "cataclysm:the_harbinger", "cataclysm:netherite_monstrosity", "cataclysm:ignis", "cataclysm:ender_guardian", "cataclysm:maledictus", "cataclysm:scylla", "witherstormmod:wither_storm", "mowziesmobs:ferrous_wroughtnaut", "mowziesmobs:frostmaw", "mowziesmobs:umvuthi", "mowziesmobs:naga", "aquamirae:captain_cornelia", "graveyard:lich", "irons_spellbooks:dead_king", "alexsmobs:void_worm", "alexsmobs:void_worm_part", "bosses_of_mass_destruction:gauntlet", "bosses_of_mass_destruction:lich", "bosses_of_mass_destruction:obsidilith", "bosses_of_mass_destruction:void_blossom")), obj -> obj instanceof String);
        BOSS_BATTLE_DISTANCE = builder.comment("Soul Like Boss Battle Distance").comment("Radius of Soul Like Boss Battle. Minimum is 1, maximum is 128.(Default is 64 blocks)").defineInRange("Soul Like Boss Battle Distance", 64, 1, 128);
        PLAYER_GAMEMODE = builder.comment("Soul Like Boss Battle Check Player Gamemode").comment("Soul Like Boss Battle Valid Player's Gamemode: [survival, adventure, creative, spectator]").defineList("Gamemode", () -> new ArrayList<String>(Arrays.asList("survival", "adventure")), obj -> obj instanceof String);
        IRON_GOLEM = builder.comment("Iron Golem Entity").comment("Iron Golem entity id.").defineList("Iron Golem Entity", () -> new ArrayList<String>(Arrays.asList("minecraft:iron_golem")), obj -> obj instanceof String);
        ANTI_IRON_GOLEM = builder.comment("Anti-Iron Golem").comment("Not allow Iron Golem hurt BOSS.").define("Anti-Iron Golem", true);
        SOUL_LIKE_BOSS_BATTLE_CONFIG = builder.build();
    }
}

