/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.sg.epicfight.gameassets.animations;

import com.merlin204.avalon.epicfight.animations.AvalonAttackAnimation;
import com.merlin204.avalon.epicfight.animations.AvalonMovementAnimation;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import com.merlin204.avalon.util.AvalonEventUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;

public class GolemHeartAnimations {
    public static final Collider GOLEM_HAND = new MultiOBBCollider(8, 0.5, 0.5, 0.5, 0.0, 0.0, 0.0);
    public static final Armatures.ArmatureAccessor<? extends Armature> ARMATURE = Armatures.ArmatureAccessor.create((String)"super_golem", (String)"golem_heart", Armature::new);
    public static AnimationManager.AnimationAccessor<StaticAnimation> IDLE;
    public static AnimationManager.AnimationAccessor<StaticAnimation> KNEEL;
    public static AnimationManager.AnimationAccessor<AvalonMovementAnimation> SNEAK;
    public static AnimationManager.AnimationAccessor<AvalonMovementAnimation> WALK;
    public static AnimationManager.AnimationAccessor<AvalonMovementAnimation> RUN;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> ATK_1;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> ATK_2;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> ATK_3;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> RUN_ATK;
    public static AnimationManager.AnimationAccessor<AvalonAttackAnimation> AIR_ATK;

    public static void buildVFXAnimations(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor armature = Armatures.ArmatureAccessor.create((String)"super_golem", (String)"golem_heart", Armature::new);
        IDLE = builder.nextAccessor("golem_heart/golem_heart_idle", accessor -> new StaticAnimation(0.15f, true, accessor, (AssetAccessor)armature));
        KNEEL = builder.nextAccessor("golem_heart/golem_heart_kneel", accessor -> new StaticAnimation(0.15f, true, accessor, (AssetAccessor)armature));
        SNEAK = builder.nextAccessor("golem_heart/golem_heart_sneak", accessor -> new AvalonMovementAnimation(0.15f, true, accessor, (AssetAccessor)armature, 1.5f));
        WALK = builder.nextAccessor("golem_heart/golem_heart_walk", accessor -> new AvalonMovementAnimation(0.15f, true, accessor, (AssetAccessor)armature, 1.5f));
        RUN = builder.nextAccessor("golem_heart/golem_heart_run", accessor -> new AvalonMovementAnimation(0.15f, true, accessor, (AssetAccessor)armature, 1.5f));
        ATK_1 = builder.nextAccessor("golem_heart/golem_heart_atk_1", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)armature, new AvalonAttackAnimation.AvalonPhase[]{GolemHeartAnimations.createSimplePhaseDownR(30, 40, 50), GolemHeartAnimations.createSimplePhaseUpL(55, 65, 60)}).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (Object)Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER));
        ATK_2 = builder.nextAccessor("golem_heart/golem_heart_atk_2", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)armature, new AvalonAttackAnimation.AvalonPhase[]{GolemHeartAnimations.createSimplePhaseUpR(30, 40, 50), GolemHeartAnimations.createSimplePhaseDownL(45, 55, 70)}).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (Object)Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER));
        ATK_3 = builder.nextAccessor("golem_heart/golem_heart_atk_3", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)armature, new AvalonAttackAnimation.AvalonPhase[]{GolemHeartAnimations.createSimplePhaseDownR(30, 40, 50), GolemHeartAnimations.createSimplePhaseUpL(30, 40, 50), GolemHeartAnimations.createSimplePhaseDownL(30, 40, 50), GolemHeartAnimations.createSimplePhaseUpR(30, 40, 50)}).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (Object)Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER));
        RUN_ATK = builder.nextAccessor("golem_heart/golem_heart_run_atk", accessor -> (AvalonAttackAnimation)new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)armature, new AvalonAttackAnimation.AvalonPhase[]{GolemHeartAnimations.createSimplePhaseDownR(25, 35, 45), GolemHeartAnimations.createSimplePhaseDownL(25, 35, 45)}).addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, (Object)Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER));
        AIR_ATK = builder.nextAccessor("golem_heart/golem_heart_air_atk", accessor -> new AvalonAttackAnimation(0.1f, accessor, (AssetAccessor)armature, new AvalonAttackAnimation.AvalonPhase[]{GolemHeartAnimations.createSimplePhaseDownR(20, 30, 50), GolemHeartAnimations.createSimplePhaseUpL(20, 30, 50), GolemHeartAnimations.createSimplePhaseDownL(20, 30, 50), GolemHeartAnimations.createSimplePhaseUpR(20, 30, 50)}));
    }

    private static AnimationEvent.InPeriodEvent groundSplitAtkUpL(int startFrame, int endFrame) {
        return AvalonEventUtils.groundSplitAtk((int)startFrame, (int)endFrame, (Joint)ARMATURE.get().searchJointByName("garm_up_4_L"), (Vec3)Vec3.f_82478_, (Vec3)new Vec3(0.0, 0.5, 0.0), (float)5.0f, (float)2.0f);
    }

    private static AnimationEvent.InPeriodEvent groundSplitAtkUpR(int startFrame, int endFrame) {
        return AvalonEventUtils.groundSplitAtk((int)startFrame, (int)endFrame, (Joint)ARMATURE.get().searchJointByName("garm_up_4_R"), (Vec3)Vec3.f_82478_, (Vec3)new Vec3(0.0, 0.5, 0.0), (float)5.0f, (float)2.0f);
    }

    private static AnimationEvent.InPeriodEvent groundSplitAtkDownL(int startFrame, int endFrame) {
        return AvalonEventUtils.groundSplitAtk((int)startFrame, (int)endFrame, (Joint)ARMATURE.get().searchJointByName("garm_down_4_L"), (Vec3)Vec3.f_82478_, (Vec3)new Vec3(0.0, 0.5, 0.0), (float)5.0f, (float)2.0f);
    }

    private static AnimationEvent.InPeriodEvent groundSplitAtkDownR(int startFrame, int endFrame) {
        return AvalonEventUtils.groundSplitAtk((int)startFrame, (int)endFrame, (Joint)ARMATURE.get().searchJointByName("garm_down_4_R"), (Vec3)Vec3.f_82478_, (Vec3)new Vec3(0.0, 0.5, 0.0), (float)5.0f, (float)2.0f);
    }

    private static AvalonAttackAnimation.AvalonPhase createSimplePhaseUpL(int startFrame, int endFrame, int waitFrame) {
        Supplier<AttackAnimation.JointColliderPair[]> supplierL = () -> {
            List<AttackAnimation.JointColliderPair> atkJoints = List.of(AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_1_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_2_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_3_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_4_L"), (Collider)GOLEM_HAND));
            return atkJoints.toArray(new AttackAnimation.JointColliderPair[0]);
        };
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)waitFrame, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])supplierL.get());
    }

    private static AvalonAttackAnimation.AvalonPhase createSimplePhaseUpR(int startFrame, int endFrame, int waitFrame) {
        Supplier<AttackAnimation.JointColliderPair[]> supplierR = () -> {
            List<AttackAnimation.JointColliderPair> atkJoints = List.of(AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_1_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_2_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_3_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_up_4_R"), (Collider)GOLEM_HAND));
            return atkJoints.toArray(new AttackAnimation.JointColliderPair[0]);
        };
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)waitFrame, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])supplierR.get());
    }

    private static AvalonAttackAnimation.AvalonPhase createSimplePhaseDownL(int startFrame, int endFrame, int waitFrame) {
        Supplier<AttackAnimation.JointColliderPair[]> supplierL = () -> {
            List<AttackAnimation.JointColliderPair> atkJoints = List.of(AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_1_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_2_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_3_L"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_4_L"), (Collider)GOLEM_HAND));
            return atkJoints.toArray(new AttackAnimation.JointColliderPair[0]);
        };
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)waitFrame, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])supplierL.get());
    }

    private static AvalonAttackAnimation.AvalonPhase createSimplePhaseDownR(int startFrame, int endFrame, int waitFrame) {
        Supplier<AttackAnimation.JointColliderPair[]> supplierL = () -> {
            List<AttackAnimation.JointColliderPair> atkJoints = List.of(AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_1_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_2_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_3_R"), (Collider)GOLEM_HAND), AttackAnimation.JointColliderPair.of((Joint)ARMATURE.get().searchJointByName("garm_down_4_R"), (Collider)GOLEM_HAND));
            return atkJoints.toArray(new AttackAnimation.JointColliderPair[0]);
        };
        return AvalonAnimationUtils.createSimplePhase((int)startFrame, (int)endFrame, (int)waitFrame, (InteractionHand)InteractionHand.MAIN_HAND, (AttackAnimation.JointColliderPair[])supplierL.get());
    }
}

