/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.registry.GTTags;

public class Utils {
    public static final int HIGHEST_Y = 255;
    public static final Component TOOLTIP_HOLD_SHIFT = Component.m_237115_((String)"tooltip.gardentrails.hold_key").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)"tooltip.gardentrails.shift").m_130940_(ChatFormatting.AQUA));
    public static final String TOOLTIP_COLUMN = "column";
    public static final String TOOLTIP_CROP = "crop";
    public static final String TOOLTIP_PERGOLA = "pergola";

    public static VoxelShape[] generateHorizontalShapes(VoxelShape[] shapes, VoxelShape ... nonRotatedShapes) {
        int n;
        VoxelShape[] newShape = new VoxelShape[]{Shapes.m_83040_()};
        VoxelShape[] newShapes = new VoxelShape[shapes.length * 4 + nonRotatedShapes.length];
        int i = 0;
        VoxelShape[] voxelShapeArray = shapes;
        int n2 = voxelShapeArray.length;
        for (n = 0; n < n2; ++n) {
            VoxelShape shape;
            newShapes[i] = shape = voxelShapeArray[n];
            ++i;
        }
        for (int rotation = 1; rotation < 4; ++rotation) {
            int j = 0;
            for (VoxelShape shape : shapes) {
                shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
                });
                shapes[j] = newShape[0];
                newShapes[i] = newShape[0];
                newShape[0] = Shapes.m_83040_();
                ++i;
                ++j;
            }
        }
        VoxelShape[] voxelShapeArray2 = nonRotatedShapes;
        n2 = voxelShapeArray2.length;
        for (n = 0; n < n2; ++n) {
            VoxelShape shape;
            newShapes[i] = shape = voxelShapeArray2[n];
            ++i;
        }
        return newShapes;
    }

    public static List<ItemStack> getLootList(ServerLevel serverWorld, BlockState stateIn, ItemStack itemStackHand, String name) {
        LootTable table = serverWorld.m_7654_().m_278653_().m_278676_(new ResourceLocation("gardentrails:blocks/" + name));
        LootParams.Builder builder = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81461_, (Object)stateIn).m_287286_(LootContextParams.f_81463_, (Object)itemStackHand).m_287286_(LootContextParams.f_81460_, (Object)new Vec3(0.0, 0.0, 0.0));
        LootParams lootParams = builder.m_287235_(LootContextParamSets.f_81421_);
        return table.m_287195_(lootParams);
    }

    public static boolean dropLootFromList(LevelAccessor worldIn, BlockPos pos, List<ItemStack> drops, float multiplier) {
        if (drops.isEmpty() || !(worldIn instanceof Level)) {
            return false;
        }
        for (ItemStack drop : drops) {
            int quantity = (int)Math.floor((float)drop.m_41613_() * multiplier);
            for (int i = 0; i < quantity; ++i) {
                Block.m_49840_((Level)((Level)worldIn), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)drop.m_41720_(), 1));
            }
        }
        return true;
    }

    public static boolean useLighter(Level worldIn, BlockPos pos, Player player, InteractionHand handIn) {
        ItemStack itemInHand = player.m_21120_(handIn);
        if (!itemInHand.m_41619_() && itemInHand.m_204117_(GTTags.INSTANCE.LIGHTERS)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            itemInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
            return true;
        }
        return false;
    }

    public static void addTooltip(List<Component> tooltip, @Nonnull Item item, String ... tooltipNames) {
        ResourceLocation itemName = item.m_204114_().m_205785_().m_135782_();
        if (itemName != null) {
            String[] tts = new String[tooltipNames.length + 1];
            System.arraycopy(tooltipNames, 0, tts, 0, tooltipNames.length);
            tts[tooltipNames.length] = itemName.m_135815_();
            Utils.addTooltip(tooltip, tts);
        }
    }

    public static void addTooltip(List<Component> tooltip, String ... tooltipNames) {
        if (Screen.m_96638_()) {
            for (String tooltipName : tooltipNames) {
                tooltip.add((Component)Component.m_237115_((String)("tooltip.gardentrails." + tooltipName)).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add(TOOLTIP_HOLD_SHIFT);
        }
    }
}

