/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.dawnoftime.gardentrails.block.IBiomeColoredBlock;
import org.dawnoftime.gardentrails.block.german.GeraniumBlock;
import org.dawnoftime.gardentrails.block.german.IvyBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleLeavesBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleSaplingBlock;
import org.dawnoftime.gardentrails.block.japanese.MapleTrunkBlock;
import org.dawnoftime.gardentrails.block.japanese.MulberryBlock;
import org.dawnoftime.gardentrails.block.japanese.PausedMapleSaplingBlock;
import org.dawnoftime.gardentrails.block.japanese.StickBundleBlock;
import org.dawnoftime.gardentrails.block.precolumbian.WildMaizeBlock;
import org.dawnoftime.gardentrails.block.roman.CypressBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredBushBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredEdgeBlock;
import org.dawnoftime.gardentrails.block.templates.BiomeColoredPlateBlock;
import org.dawnoftime.gardentrails.block.templates.DoubleCropsBlock;
import org.dawnoftime.gardentrails.block.templates.DryerBlock;
import org.dawnoftime.gardentrails.block.templates.GrowingBushBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaCropBlock;
import org.dawnoftime.gardentrails.block.templates.PergolaPlantBlock;
import org.dawnoftime.gardentrails.block.templates.PlanterBlock;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;
import org.dawnoftime.gardentrails.block.templates.WaterDoubleCropsBlock;
import org.dawnoftime.gardentrails.block.templates.WildPlantBlock;
import org.dawnoftime.gardentrails.item.templates.PotAndBlockItem;
import org.dawnoftime.gardentrails.item.templates.SoilSeedsItem;
import org.dawnoftime.gardentrails.util.Foods;
import org.dawnoftime.gardentrails.util.VoxelShapes;

public abstract class GTBlocksRegistry {
    public static GTBlocksRegistry INSTANCE;
    public static Map<TagKey<Block>, Set<Supplier<Block>>> blockTagsMap;
    public static final HashMap<String, Block> POT_BLOCKS;
    public Supplier<Block> CYPRESS;
    public final Supplier<Block> BOXWOOD_BUSH = this.register("boxwood_bush", () -> new BiomeColoredBushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_), VoxelShapes.BUSH_SHAPES, IBiomeColoredBlock.ColorType.FOLIAGE), BlockTags.f_278398_);
    public final Supplier<Block> BOXWOOD_TALL_HEDGE = this.register("boxwood_tall_hedge", () -> new BiomeColoredPlateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_), IBiomeColoredBlock.ColorType.FOLIAGE), BlockTags.f_278398_);
    public final Supplier<Block> BOXWOOD_SMALL_HEDGE = this.register("boxwood_small_hedge", () -> new BiomeColoredEdgeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_), IBiomeColoredBlock.ColorType.FOLIAGE), BlockTags.f_278398_);
    public Supplier<Block> IVY;
    public Supplier<Block> GERANIUM_PINK;
    public final Supplier<Block> PLANTER_GERANIUM_PINK = this.register("planter_geranium_pink", () -> new PlanterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50129_).m_60978_(0.6f).m_60955_()));
    public final Supplier<Block> WILD_GRAPE = this.register("wild_grape", () -> new WildPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)), BlockTags.f_278398_);
    public final Supplier<Block> BAMBOO_DRYING_TRAY = this.register("bamboo_drying_tray", () -> new DryerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_(), VoxelShapes.DRYER_SHAPES), BlockTags.f_144280_);
    public Supplier<GrowingBushBlock> CAMELLIA;
    public Supplier<MulberryBlock> MULBERRY;
    public final Supplier<WaterDoubleCropsBlock> RICE = this.registerWithItem("rice", () -> new WaterDoubleCropsBlock(2), block -> new SoilSeedsItem(block, null), BlockTags.f_144280_);
    public final Supplier<Block> STICK_BUNDLE = this.register("stick_bundle", () -> new StickBundleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56740_).m_60955_()).setBurnable(), BlockTags.f_144280_);
    public final Supplier<Block> MAPLE_RED_TRUNK = this.registerWithItem("maple_red_trunk", () -> new MapleTrunkBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_)), null, BlockTags.f_144280_);
    public final Supplier<Block> MAPLE_RED_LEAVES = this.registerWithItem("maple_red_leaves", () -> new MapleLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_)), null, BlockTags.f_144280_);
    public Supplier<Block> MAPLE_RED_SAPLING;
    public final Supplier<Block> PAUSED_MAPLE_RED_SAPLING = this.registerWithItem("paused_maple_red_sapling", () -> new PausedMapleSaplingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_)), null, BlockTags.f_144280_);
    public Supplier<SoilCropsBlock> COMMELINA;
    public final Supplier<Block> WILD_MAIZE = this.register("wild_maize", () -> new WildMaizeBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50111_)), BlockTags.f_278398_);
    public Supplier<DoubleCropsBlock> MAIZE;
    public final Supplier<PergolaBlock> IRON_PERGOLA = this.register("iron_pergola", () -> new PergolaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_)));
    public final Supplier<PergolaBlock> IRON_PERGOLA_VINE = this.registerWithItem("iron_pergola_vine", () -> new PergolaPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_)), null, new TagKey[0]);
    public final Supplier<PergolaBlock> IRON_PERGOLA_IVY = this.registerWithItem("iron_pergola_ivy", () -> new PergolaPlantBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_)), null, new TagKey[0]);
    public final Supplier<PergolaBlock> IRON_PERGOLA_GRAPE = this.registerWithItem("iron_pergola_grape", () -> new PergolaCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_), 4, 6, 0, 2, 2), null, new TagKey[0]);

    public void postRegister() {
        this.CYPRESS = this.registerWithFlowerPotItem("cypress", () -> new CypressBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_).m_60977_()).setBurnable(), block -> new PotAndBlockItem((Block)block, new Item.Properties()));
        this.MAIZE = this.registerWithFlowerPotItem("maize", () -> new DoubleCropsBlock(SoilCropsBlock.PlantType.CROP, 4), block -> new SoilSeedsItem(block, Foods.MAIZE));
        this.COMMELINA = this.registerWithFlowerPotItem("commelina", () -> new SoilCropsBlock(SoilCropsBlock.PlantType.PLAINS), block -> new SoilSeedsItem(block, null));
        this.MAPLE_RED_SAPLING = this.registerWithFlowerPotItem("maple_red_sapling", () -> new MapleSaplingBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50051_)), block -> new PotAndBlockItem((Block)block, new Item.Properties()));
        this.CAMELLIA = this.registerWithFlowerPotItem("camellia", () -> new GrowingBushBlock(SoilCropsBlock.PlantType.PLAINS, 3), "camellia_seeds", block -> new SoilSeedsItem(block, null));
        this.MULBERRY = this.registerWithFlowerPotItem("mulberry", () -> new MulberryBlock(SoilCropsBlock.PlantType.PLAINS, 3, 2), block -> new SoilSeedsItem(block, Foods.MULBERRY));
        this.IVY = this.registerWithFlowerPotItem("ivy", () -> new IvyBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50191_).m_60977_().m_60978_(0.2f).m_60918_(SoundType.f_56760_)), block -> new PotAndBlockItem((Block)block, new Item.Properties()));
        this.GERANIUM_PINK = this.registerWithFlowerPotItem("geranium_pink", () -> new GeraniumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50355_).m_222979_(BlockBehaviour.OffsetType.NONE).m_60966_().m_60918_(SoundType.f_56740_)), block -> new PotAndBlockItem((Block)block, new Item.Properties()));
    }

    public <T extends Block> Supplier<T> register(String id, Supplier<T> block) {
        return this.registerWithItem(id, block, blockObject -> new BlockItem(blockObject, new Item.Properties()), new TagKey[0]);
    }

    public <T extends Block> Supplier<T> register(String id, Supplier<T> block, TagKey<Block> ... tagKeys) {
        return this.registerWithItem(id, block, blockObject -> new BlockItem(blockObject, new Item.Properties()), tagKeys);
    }

    public abstract <T extends Block, Y extends Item> Supplier<T> registerWithItem(String var1, Supplier<T> var2, Function<T, Y> var3, TagKey<Block> ... var4);

    public abstract <T extends Block, Y extends Item> Supplier<T> registerWithFlowerPotItem(String var1, Supplier<T> var2, String var3, Function<T, Y> var4);

    public <T extends Block, Y extends Item> Supplier<T> registerWithFlowerPotItem(String id, Supplier<T> block, Function<T, Y> item) {
        return this.registerWithFlowerPotItem(id, block, id, item);
    }

    public <T extends Block> void addBlockTag(Supplier<T> block, TagKey<Block> tag) {
        blockTagsMap.computeIfAbsent(tag, k -> new HashSet()).add(block);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    static {
        blockTagsMap = new HashMap<TagKey<Block>, Set<Supplier<Block>>>();
        POT_BLOCKS = new HashMap();
    }
}

