/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.dawnoftime.gardentrails.recipe.DryerRecipe;
import org.jetbrains.annotations.NotNull;

public class DryerRecipeSerializer
implements RecipeSerializer<DryerRecipe> {
    @Nonnull
    public DryerRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("The object 'ingredient' is missing.");
        }
        if (!json.get("ingredient").isJsonObject()) {
            throw new JsonSyntaxException("'ingredient' is expected to be an object.");
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("The object 'result' is missing.");
        }
        if (!json.get("result").isJsonObject()) {
            throw new JsonSyntaxException("'result' is expected to be an object.");
        }
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
        ingredient.m_43908_()[0].m_41764_(GsonHelper.m_13824_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"), (String)"count", (int)1));
        ItemStack itemStackResult = ShapedRecipe.m_151278_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result")).m_7968_();
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int dryingTime = GsonHelper.m_13824_((JsonObject)json, (String)"dryingTime", (int)1200);
        return new DryerRecipe(recipeId, group, ingredient, itemStackResult, experience, dryingTime);
    }

    @NotNull
    public DryerRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
        String group = buffer.m_130136_(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack itemStackResult = buffer.m_130267_();
        float experience = buffer.readFloat();
        int dryingTime = buffer.m_130242_();
        return new DryerRecipe(recipeId, group, ingredient, itemStackResult, experience, dryingTime);
    }

    public void toNetwork(FriendlyByteBuf buffer, DryerRecipe recipe) {
        buffer.m_130070_(recipe.group);
        recipe.ingredient.m_43923_(buffer);
        buffer.m_130055_(recipe.result);
        buffer.writeFloat(recipe.experience);
        buffer.m_130130_(recipe.dryingTime);
    }
}

