/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.dawnoftime.gardentrails.block.templates.DoubleGrowingBushBlock;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTEntitiesRegistry;

public class SilkmothEntity
extends AmbientCreature {
    private static final EntityDataAccessor<BlockPos> ROTATION_POS = SynchedEntityData.m_135353_(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> CLOCKWISE = SynchedEntityData.m_135353_(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(SilkmothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public SilkmothEntity(Level worldIn) {
        super(GTEntitiesRegistry.INSTANCE.SILKMOTH_ENTITY.get(), worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    private float getNewRotationDistance() {
        return 0.5f + (float)Services.PLATFORM.getConfig().silkmothRotationMaxRange * this.f_19796_.m_188501_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        this.m_20088_().m_135381_(ROTATION_POS, (Object)this.m_20183_());
        return super.m_6518_(world, difficultyInstance, spawnReason, data, nbt);
    }

    protected void m_8024_() {
        double alpha;
        super.m_8024_();
        if (this.f_19797_ >= 24000 && !this.m_8077_() && Services.PLATFORM.getConfig().silkmothMustDie) {
            this.m_6469_(this.m_269291_().m_269064_(), 20.0f);
        }
        if (this.f_19796_.m_188503_(Services.PLATFORM.getConfig().silkmothRotationChange) == 0) {
            this.changeRotationPos();
        }
        BlockPos pos = (BlockPos)this.m_20088_().m_135370_(ROTATION_POS);
        double distance = ((Float)this.m_20088_().m_135370_(DISTANCE)).floatValue();
        double x = this.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double z = this.m_20189_() - ((double)pos.m_123343_() + 0.5);
        if (z == 0.0) {
            alpha = x > 0.0 ? 0.0 : Math.PI;
        } else {
            alpha = Math.atan(z / x);
            if (x > 0.0) {
                alpha += Math.PI;
            }
        }
        double d = Math.sqrt(x * x + z * z);
        d = -distance * 2.0 / (d + distance) + 1.0;
        double d2 = (Boolean)this.m_20088_().m_135370_(CLOCKWISE) != false ? d - 1.0 : 1.0 - d;
        Vec3 motionVector = this.m_20184_();
        this.m_20334_(motionVector.f_82479_ * 0.5 + Math.cos(alpha += d2 * Math.PI / 2.0) * 0.15, Math.sin((double)this.f_19797_ / 20.0) * 0.05, motionVector.f_82481_ * 0.5 + Math.sin(alpha) * 0.15);
        float rot = (float)Mth.m_14175_((double)(180.0 * alpha / Math.PI - 90.0));
        this.m_5616_(rot);
        this.m_146922_(rot);
    }

    private void changeRotationPos() {
        int horizontalRange = 5;
        int verticalRange = 2;
        int x = (int)this.m_9236_().m_46468_() % 23999;
        boolean isNight = x > 12000 && x < 23000;
        x = (int)Math.floor(this.m_20185_()) - horizontalRange;
        int y = (int)Math.floor(this.m_20186_()) - verticalRange;
        int z = (int)Math.floor(this.m_20189_()) - horizontalRange;
        ArrayList<BlockPos> listMulberry = new ArrayList<BlockPos>();
        ArrayList<BlockPos> listLight = new ArrayList<BlockPos>();
        for (int searchX = 0; searchX < 2 * horizontalRange + 1; ++searchX) {
            for (int searchZ = 0; searchZ < 2 * horizontalRange + 1; ++searchZ) {
                for (int searchY = 0; searchY < 2 * verticalRange + 1; ++searchY) {
                    BlockPos pos = new BlockPos(x + searchX, y + searchY, z + searchZ);
                    BlockState state = this.m_9236_().m_8055_(pos);
                    if (state.m_60734_() == GTBlocksRegistry.INSTANCE.MULBERRY.get()) {
                        if (((DoubleGrowingBushBlock)state.m_60734_()).isBottomCrop(state)) continue;
                        listMulberry.add(pos);
                        continue;
                    }
                    if (!isNight || state.m_60791_() < 14) continue;
                    listLight.add(pos);
                }
            }
        }
        if (!listLight.isEmpty()) {
            this.m_20088_().m_135381_(ROTATION_POS, (Object)((BlockPos)listLight.get(this.f_19796_.m_188503_(listLight.size()))));
        } else if (!listMulberry.isEmpty()) {
            this.m_20088_().m_135381_(ROTATION_POS, (Object)((BlockPos)listMulberry.get(this.f_19796_.m_188503_(listMulberry.size()))));
        } else {
            this.m_20088_().m_135381_(ROTATION_POS, (Object)new BlockPos(x + this.f_19796_.m_188503_(2 * horizontalRange + 1), y + this.f_19796_.m_188503_(2 * verticalRange + 1), z + this.f_19796_.m_188503_(2 * horizontalRange + 1)));
        }
        this.m_20088_().m_135381_(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ / 2.0f;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    protected void m_6138_() {
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public float m_6100_() {
        return super.m_6100_() * 0.9f;
    }

    @Nullable
    public SoundEvent m_7515_() {
        return !Services.PLATFORM.getConfig().silkmothMute && this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_12191_ : null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12191_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12191_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ROTATION_POS, (Object)new BlockPos((Vec3i)this.m_20183_()));
        this.m_20088_().m_135372_(CLOCKWISE, (Object)this.f_19796_.m_188499_());
        this.m_20088_().m_135372_(DISTANCE, (Object)Float.valueOf(this.getNewRotationDistance()));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_20088_().m_135381_(ROTATION_POS, (Object)new BlockPos(compound.m_128451_("RotationX"), compound.m_128451_("RotationY"), compound.m_128451_("RotationZ")));
        this.m_20088_().m_135381_(CLOCKWISE, (Object)compound.m_128471_("RotationClockwise"));
        this.m_20088_().m_135381_(DISTANCE, (Object)Float.valueOf(compound.m_128457_("RotationDistance")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("RotationX", ((BlockPos)this.m_20088_().m_135370_(ROTATION_POS)).m_123341_());
        compound.m_128405_("RotationY", ((BlockPos)this.m_20088_().m_135370_(ROTATION_POS)).m_123342_());
        compound.m_128405_("RotationZ", ((BlockPos)this.m_20088_().m_135370_(ROTATION_POS)).m_123343_());
        compound.m_128379_("RotationClockwise", ((Boolean)this.m_20088_().m_135370_(CLOCKWISE)).booleanValue());
        compound.m_128350_("RotationDistance", ((Float)this.m_20088_().m_135370_(DISTANCE)).floatValue());
    }
}

