/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.dawnoftime.gardentrails.GTConfig;
import org.dawnoftime.gardentrails.loot.GTLootModifiersForge;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTItemsRegistry;

public class GTLootModifierProvider
extends GlobalLootModifierProvider {
    private static final GTConfig config = Services.PLATFORM.getConfig();

    public GTLootModifierProvider(PackOutput output) {
        super(output, "gardentrails");
    }

    protected void start() {
        this.add("silk_in_shipwreck_treasure", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/shipwreck_treasure", GTItemsRegistry.INSTANCE.SILK.get(), 1.0f));
        this.add("grape_in_village_plains_house", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/village/village_plains_house", GTItemsRegistry.INSTANCE.GRAPE.get(), 0.5f));
        this.add("maize_in_village_savanna_house", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/village/village_savanna_house", GTBlocksRegistry.INSTANCE.MAIZE.get().m_5456_(), 0.5f));
        this.add("rice_in_village_taiga_house", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/village/village_taiga_house", GTBlocksRegistry.INSTANCE.RICE.get().m_5456_(), 0.5f));
        this.add("mulberry_in_village_taiga_house", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/village/village_taiga_house", GTBlocksRegistry.INSTANCE.MULBERRY.get().m_5456_(), 0.5f));
        this.add("grape_in_shipwreck_supply", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/shipwreck_supply", GTItemsRegistry.INSTANCE.GRAPE.get(), 0.2f));
        this.add("maize_in_shipwreck_supply", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/shipwreck_supply", GTBlocksRegistry.INSTANCE.MAIZE.get().m_5456_(), 0.2f));
        this.add("rice_in_shipwreck_supply", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/shipwreck_supply", GTBlocksRegistry.INSTANCE.RICE.get().m_5456_(), 0.2f));
        this.add("mulberry_in_shipwreck_supply", (IGlobalLootModifier)this.buildLootTable("minecraft:chests/shipwreck_supply", GTBlocksRegistry.INSTANCE.MULBERRY.get().m_5456_(), 0.2f));
    }

    private GTLootModifiersForge buildLootTable(String lootTableName, Item item, float probability) {
        return new GTLootModifiersForge(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation(lootTableName)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)probability).m_6409_()}, item);
    }
}

