/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.dawnoftime.gardentrails.entity.SilkmothEntity;
import org.jetbrains.annotations.NotNull;

public class SilkmothModel<T extends SilkmothEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("gardentrails", "silkmoth"), "main");
    private final ModelPart root;
    private final ModelPart wingLeft;
    private final ModelPart wingRight;
    private final ModelPart head;

    public SilkmothModel(ModelPart root) {
        this.root = root.m_171324_("root");
        ModelPart body = this.root.m_171324_("body");
        this.wingLeft = body.m_171324_("wingLeft");
        this.wingRight = body.m_171324_("wingRight");
        this.head = body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, -1.25f, -0.3f, 2.0f, 2.0f, 5.0f, new CubeDeformation(-0.5f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -1.5f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(-1.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition antennaLeft = head.m_171599_("antennaLeft", CubeListBuilder.m_171558_().m_171514_(12, -7).m_171488_(-2.5f, -2.5f, -4.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(-2.5f)), PartPose.m_171423_((float)-0.4f, (float)-0.5f, (float)-0.8f, (float)-0.5236f, (float)1.0472f, (float)0.0f));
        PartDefinition antennaRight = head.m_171599_("antennaRight", CubeListBuilder.m_171558_().m_171514_(12, -7).m_171488_(-2.5f, -2.5f, -4.5f, 5.0f, 6.0f, 7.0f, new CubeDeformation(-2.5f)), PartPose.m_171423_((float)0.4f, (float)-0.5f, (float)-0.8f, (float)-0.5236f, (float)-1.0472f, (float)0.0f));
        PartDefinition wingLeft = body.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(-12, 20).m_171480_().m_171488_(-3.5f, -3.5f, -3.5f, 14.0f, 7.0f, 12.0f, new CubeDeformation(-3.5f)).m_171555_(false), PartPose.m_171423_((float)0.3f, (float)-0.8f, (float)0.5f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition wingRight = body.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(-12, 20).m_171488_(-10.5f, -3.5f, -3.5f, 14.0f, 7.0f, 12.0f, new CubeDeformation(-3.5f)).m_171555_(false), PartPose.m_171423_((float)-0.3f, (float)-0.8f, (float)0.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_().m_171514_(9, 8).m_171488_(-2.5f, -2.28f, -1.55f, 5.0f, 5.0f, 5.0f, new CubeDeformation(-1.75f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float flap = 5.0f;
        float d = Math.abs(ageInTicks % flap / flap - 0.5f);
        this.wingLeft.f_104205_ = (float)(Math.PI * (double)(0.2f - d));
        this.wingRight.f_104205_ = (float)(Math.PI * (double)(-0.2f + d));
        this.head.f_104203_ = headPitch * 0.018f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.5f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

