/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.PergolaBlock;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.util.GTBlockStateProperties;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PergolaCropBlock
extends PergolaBlock {
    private static final IntegerProperty AGE_6 = GTBlockStateProperties.AGE_6;
    private final int[] moonPhasePerAge;

    public PergolaCropBlock(BlockBehaviour.Properties properties, int age2, int age3, int age4, int age5, int age6) {
        super(properties);
        this.moonPhasePerAge = new int[]{age2, age3, age4, age5, age6};
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE_6, (Comparable)Integer.valueOf(0)));
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue() || ((Boolean)state.m_61143_((Property)AXIS_Z)).booleanValue()) {
            return (Boolean)state.m_61143_((Property)AXIS_Y) != false ? VoxelShapes.PERGOLA_COLLISION_SHAPES[2] : VoxelShapes.PERGOLA_COLLISION_SHAPES[1];
        }
        return VoxelShapes.PERGOLA_COLLISION_SHAPES[0];
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return super.m_5940_(state, level, pos, context);
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE_6});
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return true;
    }

    private boolean canGrowMoonCycle(Level worldIn, int currentAge) {
        if (currentAge < 2) {
            return false;
        }
        int currentPhase = worldIn.m_6042_().m_63936_(worldIn.m_46468_());
        return (currentPhase - this.moonPhasePerAge[currentAge -= 2] + 8) % 8 < 4;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.m_5776_()) {
            if (!level.m_46749_(pos)) {
                return;
            }
            if (level.m_45524_(pos, 0) >= 8) {
                int age = (Integer)state.m_61143_((Property)AGE_6);
                if (age < 2) {
                    if (random.m_188503_(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE_6, (Comparable)Integer.valueOf(age + 1)), 2);
                    }
                } else {
                    BlockPos adjacentPos;
                    BlockState adjacentState;
                    if (this.canGrowMoonCycle((Level)level, age) && random.m_188503_(Services.PLATFORM.getConfig().climbingPlantGrowthChance) == 0) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE_6, (Comparable)Integer.valueOf(2 + (age - 1) % 5)), 2);
                    }
                    if (random.m_188503_(Services.PLATFORM.getConfig().climbingPlantSpreadChance) == 0 && (adjacentState = level.m_8055_(adjacentPos = PergolaCropBlock.randomSpread(pos, random))).m_60734_() == GTBlocksRegistry.INSTANCE.IRON_PERGOLA.get()) {
                        level.m_7731_(adjacentPos, this.copyShapeToPergola(adjacentState, this), 2);
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)AGE_6) > 2 && this.dropPlant(state, level, pos, player.m_21120_(hand))) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE_6, (Comparable)Integer.valueOf(2)), 2);
            level.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_()) {
            this.dropPlant(state, level, pos, player.m_21120_(hand));
            level.m_7731_(pos, this.copyShapeToPergola(state, GTBlocksRegistry.INSTANCE.IRON_PERGOLA.get()), 2);
            level.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean dropPlant(BlockState state, Level level, BlockPos pos, ItemStack heldItemStack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_());
            List<ItemStack> drops = Utils.getLootList(serverLevel, state, heldItemStack, blockId.m_135815_() + "_" + state.m_61143_((Property)AGE_6));
            return Utils.dropLootFromList((LevelAccessor)level, pos, drops, 1.0f);
        }
        return false;
    }
}

