/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.gardentrails.block.templates.BlockGT;
import org.dawnoftime.gardentrails.registry.GTBlocksRegistry;
import org.dawnoftime.gardentrails.registry.GTItemsRegistry;
import org.dawnoftime.gardentrails.util.GTBlockStateProperties;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class PergolaBlock
extends BlockGT {
    public static final BooleanProperty AXIS_X = GTBlockStateProperties.AXIS_X;
    public static final BooleanProperty AXIS_Y = GTBlockStateProperties.AXIS_Y;
    public static final BooleanProperty AXIS_Z = GTBlockStateProperties.AXIS_Z;

    public PergolaBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.PERGOLA_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS_Y, AXIS_X, AXIS_Z});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)AXIS_Y)).booleanValue()) {
            int index = 3;
            if (((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue()) {
                ++index;
            }
            if (((Boolean)state.m_61143_((Property)AXIS_Z)).booleanValue()) {
                index += 2;
            }
            return index;
        }
        int index = (Boolean)state.m_61143_((Property)AXIS_Z) != false ? 1 : 0;
        return (Boolean)state.m_61143_((Property)AXIS_X) != false ? index * 2 : index;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60734_() != this && (state = super.m_5573_(context)) == null) {
            return null;
        }
        return switch (context.m_43719_().m_122434_()) {
            case Direction.Axis.X -> (BlockState)state.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(true));
            case Direction.Axis.Z -> (BlockState)state.m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(true));
            default -> (BlockState)state.m_61124_((Property)AXIS_Y, (Comparable)Boolean.valueOf(true));
        };
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if (useContext.m_43723_() != null && useContext.m_43723_().m_6047_()) {
            return false;
        }
        if (itemstack.m_41720_() == this.m_5456_()) {
            return switch (useContext.m_43719_().m_122434_()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> {
                    if (!((Boolean)state.m_61143_((Property)AXIS_X)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Y -> {
                    if (!((Boolean)state.m_61143_((Property)AXIS_Y)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.Axis.Z -> (Boolean)state.m_61143_((Property)AXIS_Z) == false;
            };
        }
        return false;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        boolean x = (Boolean)state.m_61143_((Property)AXIS_X);
        boolean z = (Boolean)state.m_61143_((Property)AXIS_Z);
        return switch (rotation) {
            case Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)state.m_61124_((Property)AXIS_X, (Comparable)Boolean.valueOf(z))).m_61124_((Property)AXIS_Z, (Comparable)Boolean.valueOf(x));
            default -> state;
        };
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "pergola");
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockState stateUnder;
        if (player.m_7500_()) {
            Item item = player.m_21120_(hand).m_41720_();
            return this.tryPutPlant(item, state, level, pos);
        }
        if (((Boolean)state.m_61143_((Property)AXIS_Y)).booleanValue() && ((stateUnder = level.m_8055_(pos.m_7495_())).m_60734_() == Blocks.f_50440_ || stateUnder.m_204336_(BlockTags.f_144274_))) {
            Item item = player.m_21120_(hand).m_41720_();
            return this.tryPutPlant(item, state, level, pos);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tryPutPlant(Item itemInHand, BlockState currentState, @NotNull Level level, @NotNull BlockPos pos) {
        if (itemInHand == Blocks.f_50191_.m_5456_()) {
            level.m_7731_(pos, this.copyShapeToPergola(currentState, GTBlocksRegistry.INSTANCE.IRON_PERGOLA_VINE.get()), 2);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand == GTBlocksRegistry.INSTANCE.IVY.get().m_5456_()) {
            level.m_7731_(pos, this.copyShapeToPergola(currentState, GTBlocksRegistry.INSTANCE.IRON_PERGOLA_IVY.get()), 2);
            return InteractionResult.SUCCESS;
        }
        if (itemInHand == GTItemsRegistry.INSTANCE.GRAPE_SEEDS.get()) {
            level.m_7731_(pos, this.copyShapeToPergola(currentState, GTBlocksRegistry.INSTANCE.IRON_PERGOLA_GRAPE.get()), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState copyShapeToPergola(@NotNull BlockState currentState, PergolaBlock targetPergola) {
        return (BlockState)((BlockState)((BlockState)targetPergola.m_49966_().m_61124_((Property)AXIS_X, (Comparable)((Boolean)currentState.m_61143_((Property)AXIS_X)))).m_61124_((Property)AXIS_Y, (Comparable)((Boolean)currentState.m_61143_((Property)AXIS_Y)))).m_61124_((Property)AXIS_Z, (Comparable)((Boolean)currentState.m_61143_((Property)AXIS_Z)));
    }

    public static BlockPos randomSpread(BlockPos pos, RandomSource random) {
        return switch (random.m_188503_(5)) {
            case 0 -> pos.m_122012_();
            case 1 -> pos.m_122029_();
            case 2 -> pos.m_122019_();
            case 3 -> pos.m_122024_();
            default -> pos.m_7494_();
        };
    }
}

