/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.SoilCropsBlock;
import org.dawnoftime.gardentrails.util.GTBlockStateProperties;
import org.dawnoftime.gardentrails.util.Utils;

public class GrowingBushBlock
extends SoilCropsBlock {
    public final VoxelShape[] SHAPES;
    public final int cutAge;
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    private static final BooleanProperty CUT = GTBlockStateProperties.CUT;

    public GrowingBushBlock(SoilCropsBlock.PlantType plantType, int cutAge) {
        super(plantType);
        this.cutAge = cutAge;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)CUT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.makeShapes();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, PERSISTENT, CUT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        int index = (Integer)state.m_61143_((Property)AGE);
        return (Boolean)state.m_61143_((Property)CUT) != false ? this.SHAPES[5] : this.SHAPES[index];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)AGE) == 0 ? Shapes.m_83040_() : super.m_5940_(state, worldIn, pos, context);
    }

    public VoxelShape[] makeShapes() {
        return new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.5, (double)11.0), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.5, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)12.0, (double)14.5), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0)};
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public BooleanProperty getCutProperty() {
        return CUT;
    }

    public int m_7419_() {
        return 5;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult ray) {
        if (super.m_6227_(state, worldIn, pos, playerIn, hand, ray) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_52307_(state) && !playerIn.m_7500_() && !worldIn.m_5776_()) {
            ItemStack itemStackHand = playerIn.m_21120_(hand);
            boolean holdShears = itemStackHand.m_150930_(Items.f_42574_);
            if (holdShears) {
                itemStackHand.m_41622_(1, (LivingEntity)playerIn, p -> p.m_21190_(hand));
            }
            ResourceLocation resourceLocation = this.m_204297_().m_205785_().m_135782_();
            this.harvestWithoutBreaking(state, worldIn, pos, itemStackHand, resourceLocation.m_135815_(), holdShears ? 1.5f : 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void harvestWithoutBreaking(BlockState state, Level worldIn, BlockPos pos, ItemStack itemStackHand, String blockName, float dropMultiplier) {
        List<ItemStack> drops = Utils.getLootList((ServerLevel)worldIn, state, itemStackHand, blockName);
        Utils.dropLootFromList((LevelAccessor)worldIn, pos, drops, dropMultiplier);
        worldIn.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
        worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.cutAge))).m_61124_((Property)CUT, (Comparable)Boolean.valueOf(true)), 2);
    }
}

