/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.templates;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.templates.WaterloggedBlock;
import org.dawnoftime.gardentrails.blockentity.DryerBlockEntity;
import org.dawnoftime.gardentrails.registry.GTBlockEntitiesRegistry;
import org.dawnoftime.gardentrails.util.GTBlockStateProperties;
import org.jetbrains.annotations.NotNull;

public class DryerBlock
extends WaterloggedBlock
implements EntityBlock {
    public static final IntegerProperty SIZE = GTBlockStateProperties.SIZE_0_2;

    public DryerBlock(BlockBehaviour.Properties properties, VoxelShape[] shapes) {
        super(properties, shapes);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, @NotNull BlockEntityType<T> entityType) {
        return !pLevel.m_5776_() ? (pLevel1, pPos, pState1, entity) -> ((DryerBlockEntity)entity).tick() : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SIZE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)SIZE);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (state.m_60734_() == this) {
            return (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(context.m_43725_().m_8055_(pos.m_7494_()).m_60734_() == this ? 2 : 1));
        }
        return super.m_5573_(context);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if ((Integer)state.m_61143_((Property)SIZE) == 0 && itemstack.m_41720_() == this.m_5456_()) {
            return useContext.m_7058_();
        }
        return false;
    }

    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.m_60734_() != newState.m_60734_() && (tileEntity = worldIn.m_7702_(pos)) instanceof DryerBlockEntity) {
            DryerBlockEntity dryerBlockEntity = (DryerBlockEntity)tileEntity;
            dryerBlockEntity.itemHandler.m_19195_().forEach(h -> {
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)h);
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)h);
            });
        }
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState stateDown = worldIn.m_8055_(pos = pos.m_7495_());
        if (stateDown.m_60734_() == this) {
            return (Integer)stateDown.m_61143_((Property)SIZE) != 0;
        }
        return Block.m_49936_((BlockGetter)worldIn, (BlockPos)pos);
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing == Direction.DOWN && !this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (facing == Direction.UP) {
            return (BlockState)stateIn.m_61124_((Property)SIZE, (Comparable)Integer.valueOf((Integer)stateIn.m_61143_((Property)SIZE) != 0 && facingState.m_60734_() == this ? 2 : 1));
        }
        return stateIn;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return GTBlockEntitiesRegistry.INSTANCE.DRYER.get().m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!worldIn.m_5776_() && handIn == InteractionHand.MAIN_HAND && (blockEntity = worldIn.m_7702_(pos)) instanceof DryerBlockEntity) {
            DryerBlockEntity dryerEntity = (DryerBlockEntity)blockEntity;
            if (player.m_6047_()) {
                return dryerEntity.dropOneItem(worldIn, pos);
            }
            ItemStack handStack = player.m_21120_(handIn);
            return dryerEntity.tryInsertItemStack(handStack, (Integer)state.m_61143_((Property)SIZE) == 0, worldIn, pos, player);
        }
        return InteractionResult.FAIL;
    }
}

