/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.roman;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.IBiomeColoredBlock;
import org.dawnoftime.gardentrails.block.IBlockGeneration;
import org.dawnoftime.gardentrails.block.templates.BlockGT;
import org.dawnoftime.gardentrails.util.GTBlockStateProperties;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class CypressBlock
extends BlockGT
implements IBlockGeneration,
IBiomeColoredBlock {
    public static final IntegerProperty SIZE = GTBlockStateProperties.SIZE_0_5;

    public CypressBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.CYPRESS_SHAPES);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SIZE});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)SIZE);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader worldIn, BlockPos pos) {
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP) || worldIn.m_8055_(pos.m_7495_()).m_60734_() == this;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.m_21120_(handIn);
        if (player.m_6047_()) {
            BlockPos topPos2 = this.getHighestCypressPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.m_5776_()) {
                    worldIn.m_7731_(topPos2, Blocks.f_50016_.m_49966_(), 35);
                    if (!player.m_7500_()) {
                        Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.m_41619_() && heldItemStack.m_41720_() == this.m_5456_() && (topPos = this.getHighestCypressPos(worldIn, pos).m_7494_()).m_123342_() <= 255) {
            if (!worldIn.m_5776_() && worldIn.m_8055_(topPos).m_60795_()) {
                worldIn.m_7731_(topPos, this.m_49966_(), 11);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    private BlockPos getHighestCypressPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.m_123342_() <= 255 && worldIn.m_8055_(pos.m_6630_(yOffset)).m_60734_() == this) {
            ++yOffset;
        }
        return pos.m_6630_(yOffset - 1);
    }

    public VoxelShape m_7947_(BlockState p_230335_1_, BlockGetter p_230335_2_, BlockPos p_230335_3_) {
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        int size;
        BlockState adjacentState = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        int n = size = adjacentState.m_60734_() == this ? Math.min((Integer)adjacentState.m_61143_((Property)SIZE) + 1, 5) : 1;
        if (size < 3) {
            return (BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size));
        }
        adjacentState = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        return (BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(adjacentState.m_60734_() == this ? size : 0));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        int size;
        if (!facing.m_122434_().m_122478_()) {
            return stateIn;
        }
        if (!this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState adjacentState = worldIn.m_8055_(currentPos.m_7494_());
        int n = size = adjacentState.m_60734_() == this ? Math.min((Integer)adjacentState.m_61143_((Property)SIZE) + 1, 5) : 1;
        if (size < 3) {
            return (BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size));
        }
        adjacentState = worldIn.m_8055_(currentPos.m_7495_());
        return (BlockState)this.m_49966_().m_61124_((Property)SIZE, (Comparable)Integer.valueOf(adjacentState.m_60734_() == this ? size : 0));
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos posDown;
        BlockState stateDown;
        if (!(!worldIn.m_46758_(pos.m_7494_()) || rand.m_188503_(15) != 1 || (stateDown = worldIn.m_8055_(posDown = pos.m_7495_())).m_60815_() && stateDown.m_60783_((BlockGetter)worldIn, posDown, Direction.UP))) {
            double x = (float)pos.m_123341_() + rand.m_188501_();
            double y = (double)pos.m_123342_() - 0.05;
            double z = (float)pos.m_123343_() + rand.m_188501_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        if ((Integer)state.m_61143_((Property)SIZE) == 1) {
            BlockPos abovePos = pos.m_7494_();
            if (level.m_8055_(pos.m_6625_(5)).m_60734_() != this && level.m_46859_(abovePos) && source.m_188503_(16) == 0) {
                level.m_7731_(abovePos, this.m_49966_(), 2);
            }
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "column");
    }

    @Override
    public IBiomeColoredBlock.ColorType getColorType() {
        return IBiomeColoredBlock.ColorType.FOLIAGE;
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        if (!groundState.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        int maxSize = 2 + random.m_188503_(5);
        for (int i = 0; i < maxSize; ++i) {
            if (world.m_8055_(pos.m_6630_(i)).m_60795_()) continue;
            return false;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(0)), 2);
        int size = 1;
        for (int i = maxSize; i > 0; --i) {
            world.m_7731_(pos.m_6630_(i), (BlockState)state.m_61124_((Property)SIZE, (Comparable)Integer.valueOf(size)), 2);
            if (size >= 5) continue;
            ++size;
        }
        return true;
    }
}

