/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.precolumbian;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.gardentrails.block.IBlockGeneration;
import org.dawnoftime.gardentrails.block.templates.WildPlantBlock;
import org.jetbrains.annotations.NotNull;

public class WildMaizeBlock
extends WildPlantBlock
implements IBlockGeneration {
    private static final VoxelShape VS = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;

    public WildMaizeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM));
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Vec3 vec3d = state.m_60824_(worldIn, pos);
        return VS.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) == Half.TOP) {
            return true;
        }
        return super.m_7898_(state, worldIn, pos);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (!context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60629_(context)) {
            return null;
        }
        return super.m_5573_(context);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)Half.TOP), 10);
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.m_5776_() && player.m_7500_() && state.m_61143_(HALF) == Half.TOP && (adjacentState = level.m_8055_(adjacentPos = pos.m_7495_())).m_60713_((Block)this) && adjacentState.m_61143_(HALF) == Half.BOTTOM) {
            level.m_7731_(adjacentPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, adjacentPos, Block.m_49956_((BlockState)state));
        }
        super.m_5707_(level, pos, state, player);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().m_122479_()) {
            return stateIn;
        }
        if (facing == Direction.UP && stateIn.m_61143_(HALF) == Half.BOTTOM) {
            if (facingState.m_60734_() == this && facingState.m_61143_(HALF) == Half.TOP) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (facing == Direction.DOWN) {
            if (stateIn.m_61143_(HALF) == Half.TOP ? facingState.m_60734_() == this && facingState.m_61143_(HALF) == Half.BOTTOM : this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        if (!world.m_8055_(pos.m_7494_()).m_60795_()) {
            return false;
        }
        world.m_7731_(pos, state, 2);
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)Half.TOP), 2);
        return true;
    }
}

