/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.gardentrails.block.japanese;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.gardentrails.block.IBlockChain;
import org.dawnoftime.gardentrails.block.templates.BlockGT;
import org.dawnoftime.gardentrails.platform.Services;
import org.dawnoftime.gardentrails.registry.GTItemsRegistry;
import org.dawnoftime.gardentrails.util.Utils;
import org.dawnoftime.gardentrails.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class StickBundleBlock
extends BlockGT
implements IBlockChain {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    private static final IntegerProperty AGE = BlockStateProperties.f_61407_;

    public StickBundleBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY), VoxelShapes.STICK_BUNDLE_SHAPES);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)Half.TOP));
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.m_61143_(HALF) == Half.BOTTOM ? 1 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, AGE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        if (!world.m_8055_((pos = context.m_8083_()).m_7495_()).m_60629_(context) || !this.m_7898_(this.m_49966_(), (LevelReader)world, pos)) {
            return null;
        }
        return super.m_5573_(context);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7495_(), (BlockState)state.m_61124_(HALF, (Comparable)Half.BOTTOM), 10);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().m_122479_()) {
            return stateIn;
        }
        if (facing == Direction.UP && stateIn.m_61143_(HALF) == Half.BOTTOM) {
            if (facingState.m_60734_() == this && facingState.m_61143_(HALF) == Half.TOP) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (facing == Direction.DOWN && stateIn.m_61143_(HALF) == Half.TOP) {
            if (facingState.m_60734_() == this && facingState.m_61143_(HALF) == Half.BOTTOM) {
                return stateIn;
            }
            return Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        pos = pos.m_7494_();
        BlockState stateUp = worldIn.m_8055_(pos);
        return state.m_61143_(HALF) == Half.BOTTOM || StickBundleBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos, (Direction)Direction.DOWN) || IBlockChain.canBeChained(stateUp, true);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            ItemStack itemstack;
            if ((Integer)state.m_61143_((Property)AGE) == 0 && (itemstack = player.m_21120_(handIn)).m_41720_() == GTItemsRegistry.INSTANCE.SILK_WORMS.get() && !itemstack.m_41619_()) {
                itemstack.m_41774_(1);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                if (state.m_61143_(HALF) == Half.TOP) {
                    worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                } else {
                    worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.TOP)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 10);
                }
                return InteractionResult.SUCCESS;
            }
            if ((Integer)state.m_61143_((Property)AGE) == 3) {
                List<ItemStack> drops = Utils.getLootList((ServerLevel)worldIn, state, player.m_21120_(handIn), Objects.requireNonNull(this.m_204297_().m_205785_()).m_135782_().m_135815_() + "_harvest");
                Utils.dropLootFromList((LevelAccessor)worldIn, pos, drops, 1.0f);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                worldIn.m_5594_(null, pos, SoundEvents.f_11988_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (state.m_61143_(HALF) == Half.TOP) {
                    worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                } else {
                    worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.TOP)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 10);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > 0 && (Integer)state.m_61143_((Property)AGE) < 3 && state.m_61143_(HALF) == Half.TOP;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int growth = (Integer)state.m_61143_((Property)AGE);
        if (growth > 0 && growth < 3 && random.m_188503_(Services.PLATFORM.getConfig().stickBundleGrowthChance) == 0) {
            worldIn.m_7731_(pos, (BlockState)worldIn.m_8055_(pos).m_61124_((Property)AGE, (Comparable)Integer.valueOf(growth + 1)), 10);
            worldIn.m_7731_(pos.m_7495_(), (BlockState)worldIn.m_8055_(pos.m_7495_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(growth + 1)), 10);
        }
    }

    @Override
    public boolean canConnectToChainUnder(BlockState state) {
        return false;
    }

    public void m_5707_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockPos adjacentPos;
        BlockState adjacentState;
        if (!level.m_5776_() && player.m_7500_() && state.m_61143_(HALF) == Half.TOP && (adjacentState = level.m_8055_(adjacentPos = pos.m_7495_())).m_60713_((Block)this) && adjacentState.m_61143_(HALF) == Half.BOTTOM) {
            level.m_7731_(adjacentPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, adjacentPos, Block.m_49956_((BlockState)state));
        }
        super.m_5707_(level, pos, state, player);
    }
}

