/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.model.FusionBlockModel;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.model.types.connecting.predicates.PredicateRegistryImpl;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ExtendedBlockModelDeserializer.class}, priority=900)
public class BlockModelDeserializerMixin {
    @Unique
    private static final ThreadLocal<Boolean> SHOULD_IGNORE = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"deserialize"}, at={@At(value="HEAD")}, cancellable=true)
    private void deserialize(JsonElement json, Type type, JsonDeserializationContext context, CallbackInfoReturnable<BlockModel> ci) throws JsonParseException {
        ResourceLocation loader;
        if (SHOULD_IGNORE.get().booleanValue()) {
            return;
        }
        JsonElement loaderJson = json.getAsJsonObject().get("loader");
        if (loaderJson != null && loaderJson.isJsonPrimitive() && loaderJson.getAsJsonPrimitive().isString() && IdentifierUtil.isValidIdentifier(loaderJson.getAsString()) && (loader = new ResourceLocation(loaderJson.getAsString())).m_135827_().equals("fusion") && loader.m_135815_().equals("model")) {
            ModelInstance<?> model;
            ModelTypeRegistryImpl.finalizeRegistration();
            PredicateRegistryImpl.finalizeRegistration();
            SHOULD_IGNORE.set(true);
            try {
                model = ModelTypeRegistryImpl.deserializeModelData(json.getAsJsonObject());
            }
            finally {
                SHOULD_IGNORE.set(false);
            }
            FusionBlockModel newModel = new FusionBlockModel(model);
            ci.setReturnValue((Object)newModel);
        }
    }
}

