/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.structure;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.shelmarow.nightfall_invade.entity.NFIEntities;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;
import net.shelmarow.nightfall_invade.structure.NFIStructureType;
import org.jetbrains.annotations.NotNull;

public class GateOfDisaster
extends Structure {
    public static final ResourceLocation GATE_OF_DISASTER_P1 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"gate_of_disaster_part1");
    public static final ResourceLocation GATE_OF_DISASTER_P2 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"gate_of_disaster_part2");
    public static final ResourceLocation GATE_OF_DISASTER_P3 = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"gate_of_disaster_part3");
    public static final Codec<GateOfDisaster> CODEC = GateOfDisaster.m_226607_(GateOfDisaster::new);
    private static final Map<ResourceLocation, BlockPos> OFFSET = new HashMap<ResourceLocation, BlockPos>();

    protected GateOfDisaster(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    @NotNull
    protected Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        StructureTemplateManager templateManager = context.f_226625_();
        StructureTemplate template = templateManager.m_230359_(GATE_OF_DISASTER_P1);
        StructureTemplate template2 = templateManager.m_230359_(GATE_OF_DISASTER_P3);
        int centerX = (context.f_226628_().f_45578_ << 4) + 7;
        int centerZ = (context.f_226628_().f_45579_ << 4) + 7;
        int centerY = context.f_226622_().m_223221_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        BlockPos basePos = new BlockPos(centerX, centerY, centerZ);
        Rotation rotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        Vec3i size = template.m_163808_(rotation);
        Vec3i size2 = template2.m_163808_(rotation);
        BlockPos[] cornerOffsets = new BlockPos[]{new BlockPos(-size.m_123341_() / 2, 0, -size.m_123343_() / 2), new BlockPos(size.m_123341_() / 2, 0, -size.m_123343_() / 2), new BlockPos(-size2.m_123341_() / 2, 0, size2.m_123343_() / 2), new BlockPos(size2.m_123341_() / 2, 0, size2.m_123343_() / 2)};
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        int minAllowedY = context.f_226622_().m_6337_() - 30;
        int maxAllowedY = context.f_226622_().m_6337_() + 30;
        for (BlockPos offset : cornerOffsets) {
            BlockPos rotatedCorner = basePos.m_121955_((Vec3i)offset.m_7954_(rotation));
            int groundY = generator.m_223221_(rotatedCorner.m_123341_(), rotatedCorner.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState);
            BlockState groundBlock = generator.m_214184_(rotatedCorner.m_123341_(), rotatedCorner.m_123343_(), heightAccessor, randomState).m_183556_(groundY - 1);
            if (groundY >= minAllowedY && groundY <= maxAllowedY && Math.abs(groundY - centerY) <= 5 && groundBlock.m_60819_().m_76178_()) continue;
            return Optional.empty();
        }
        return GateOfDisaster.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context, rotation));
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return (StructureType)NFIStructureType.GATE_OF_DISASTER.get();
    }

    public static void start(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieceList, RandomSource random) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos rotationOffSet = new BlockPos(-48, 0, 0).m_7954_(rotation);
        BlockPos blockpos = rotationOffSet.m_7918_(x, pos.m_123342_(), z);
        pieceList.m_142679_((StructurePiece)new Piece(templateManager, GATE_OF_DISASTER_P1, blockpos, rotation));
        rotationOffSet = new BlockPos(0, 0, 0).m_7954_(rotation);
        blockpos = rotationOffSet.m_7918_(x, pos.m_123342_(), z);
        pieceList.m_142679_((StructurePiece)new Piece(templateManager, GATE_OF_DISASTER_P2, blockpos, rotation));
        rotationOffSet = new BlockPos(48, 0, 0).m_7954_(rotation);
        blockpos = rotationOffSet.m_7918_(x, pos.m_123342_(), z);
        pieceList.m_142679_((StructurePiece)new Piece(templateManager, GATE_OF_DISASTER_P3, blockpos, rotation));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, Rotation rotation) {
        StructureTemplateManager templateManager = context.f_226625_();
        int centerX = context.f_226628_().m_45604_();
        int centerZ = context.f_226628_().m_45605_();
        int height = context.f_226622_().m_223221_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_());
        BlockPos spawnPos = new BlockPos(centerX, height, centerZ);
        GateOfDisaster.start(templateManager, spawnPos, rotation, (StructurePieceAccessor)builder, (RandomSource)context.f_226626_());
    }

    static {
        OFFSET.put(GATE_OF_DISASTER_P1, new BlockPos(0, 0, 0));
        OFFSET.put(GATE_OF_DISASTER_P2, new BlockPos(0, 0, 0));
        OFFSET.put(GATE_OF_DISASTER_P3, new BlockPos(0, 0, 0));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager templateManagerIn, ResourceLocation resourceLocationIn, BlockPos pos, Rotation rotation) {
            super((StructurePieceType)NFIStructureType.GATE_OF_DISASTER_PIECE.get(), 0, templateManagerIn, resourceLocationIn, resourceLocationIn.toString(), Piece.makeSettings(rotation), Piece.makePosition(resourceLocationIn, pos));
        }

        public Piece(StructureTemplateManager templateManagerIn, CompoundTag tagCompound) {
            super((StructurePieceType)NFIStructureType.GATE_OF_DISASTER_PIECE.get(), tagCompound, templateManagerIn, resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot"))));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.f_226956_(), tag);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_));
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos pos) {
            return pos.m_121955_((Vec3i)OFFSET.get(location));
        }

        protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag tagCompound) {
            super.m_183620_(pContext, tagCompound);
            tagCompound.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        public void m_213694_(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            super.m_213694_(level, manager, generator, random, box, chunkPos, pos);
            BoundingBox pieceBox = this.m_73547_();
            int minX = pieceBox.m_162395_();
            int maxX = pieceBox.m_162399_();
            int minZ = pieceBox.m_162398_();
            int maxZ = pieceBox.m_162401_();
            int bottomY = pieceBox.m_162396_();
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos.MutableBlockPos supportPos = new BlockPos.MutableBlockPos(x, bottomY - 1, z);
                    if (!box.m_71051_((Vec3i)supportPos)) continue;
                    while (this.canReplace(level, (BlockPos)supportPos) && supportPos.m_123342_() > level.m_141937_()) {
                        level.m_7731_((BlockPos)supportPos, Blocks.f_50735_.m_49966_(), 2);
                        supportPos.m_122184_(0, -1, 0);
                    }
                }
            }
        }

        public boolean canReplace(WorldGenLevel level, BlockPos blockPos) {
            BlockState blockState = level.m_8055_(blockPos);
            return blockState.m_60812_((BlockGetter)level, blockPos).m_83281_();
        }

        protected void m_213704_(@NotNull String pName, @NotNull BlockPos pPos, @NotNull ServerLevelAccessor pLevel, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox) {
            if (pName.equals("boss_spawn")) {
                Arterius boss = (Arterius)((EntityType)NFIEntities.ARTERIUS.get()).m_20615_((Level)pLevel.m_6018_());
                if (boss != null) {
                    boss.m_7678_((double)pPos.m_123341_() + 0.5, pPos.m_123342_() + 1, (double)pPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    pLevel.m_7967_((Entity)boss);
                }
                pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }
}

