/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.entity.spear_knight;

import com.google.common.collect.ImmutableMap;
import com.hm.efn.gameasset.animations.EFNDodgeAnimations;
import com.hm.efn.gameasset.animations.EFNLanceAnimations;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.shelmarow.combat_evolution.ai.BehaviorUtils;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.effect.CEMobEffects;
import net.shelmarow.combat_evolution.execution.ExecutionTypeManager;
import net.shelmarow.combat_evolution.iml.CustomExecuteEntity;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import net.shelmarow.nightfall_invade.config.boss.BossConfig;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;
import net.shelmarow.nightfall_invade.entity.spear_knight.ai.ArteriusAI;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ArteriusPatch
extends CEHumanoidPatch
implements CustomExecuteEntity {
    private int stunLevel = 0;
    private int lastStunTime = 0;

    public ArteriusPatch() {
        super(Factions.NEUTRAL);
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.BLOCK, (AssetAccessor)Animations.SPEAR_GUARD);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)EFNLanceAnimations.NF_MEEN_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)EFNLanceAnimations.NF_MEEN_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.RUN, (AssetAccessor)EFNLanceAnimations.NF_MEEN_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, (AssetAccessor)EFNLanceAnimations.NF_MEEN_RUN);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, (AssetAccessor)Animations.BIPED_COMMON_NEUTRALIZED);
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SPEAR, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.BLOCK, (Object)Animations.SPEAR_GUARD), Pair.of((Object)LivingMotions.IDLE, (Object)EFNLanceAnimations.NF_MEEN_IDLE), Pair.of((Object)LivingMotions.WALK, (Object)EFNLanceAnimations.NF_MEEN_WALK), Pair.of((Object)LivingMotions.RUN, (Object)EFNLanceAnimations.NF_MEEN_RUN), Pair.of((Object)LivingMotions.CHASE, (Object)EFNLanceAnimations.NF_MEEN_RUN), Pair.of((Object)LivingMotions.DEATH, (Object)Animations.BIPED_COMMON_NEUTRALIZED))));
        this.guardHitMotions.put(CapabilityItem.WeaponCategories.SPEAR, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT3)));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SPEAR, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, ArteriusAI.NORMAL));
    }

    public void playGuardBreakSound() {
        this.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 0.0f, 0.0f);
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult result = super.attack(damageSource, target, hand);
        if (result.resultType == AttackResult.ResultType.SUCCESS && target.m_6084_()) {
            if (target.m_20094_() <= 0) {
                target.m_20254_(5);
            }
            EpicFightDamageSource source = this.getDamageSource(damageSource.getAnimation(), hand).addRuntimeTag(DamageTypeTags.f_268745_);
            int pre = target.f_19802_;
            target.f_19802_ = 0;
            float fireDamage = ((Double)BossConfig.ARTERIUS_EX_FIRE_DAMAGE.get()).floatValue();
            target.m_6469_((DamageSource)source, (float)(((PathfinderMob)this.original).m_21133_(Attributes.f_22281_) * (double)fireDamage));
            target.f_19802_ = pre;
        }
        return result;
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        Entity entity = this.original;
        if (entity instanceof Arterius) {
            Arterius entity2 = (Arterius)entity;
            double maxStamina = entity2.m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
            ILivingEntityData entityData = (ILivingEntityData)this;
            entity2.setStamina((float)((double)entityData.combat_evolution$getStamina((LivingEntity)this.original) / maxStamina));
        }
        if (this.stunLevel > 0 && ((PathfinderMob)this.original).f_19797_ - this.lastStunTime >= 100) {
            --this.stunLevel;
            this.lastStunTime = ((PathfinderMob)this.original).f_19797_;
        }
    }

    public void onDeath(LivingDeathEvent event) {
        super.onDeath(event);
    }

    public void onCommonHurt(DamageSource damageSource) {
        Arterius arterius = (Arterius)this.getOriginal();
        if (arterius.isInBattle()) {
            super.onCommonHurt(damageSource);
        }
    }

    public float getHurtImpactPercent(DamageSource damageSource) {
        LivingEntity livingEntity;
        CapabilityItem capabilityItem;
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity && (capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)(livingEntity = (LivingEntity)entity).m_21120_(InteractionHand.MAIN_HAND))) != null) {
            WeaponCategory category = capabilityItem.getWeaponCategory();
            if (category == CapabilityItem.WeaponCategories.DAGGER) {
                return 0.15f;
            }
            if (category == CapabilityItem.WeaponCategories.SWORD) {
                return 0.35f;
            }
            if (category == CapabilityItem.WeaponCategories.AXE) {
                return 0.45f;
            }
            if (category == CapabilityItem.WeaponCategories.SPEAR) {
                return 0.5f;
            }
            if (category == CapabilityItem.WeaponCategories.GREATSWORD) {
                return 0.55f;
            }
        }
        return 0.4f;
    }

    public void onAttackParried(DamageSource damageSource, LivingEntityPatch<?> blocker) {
        String name;
        CECombatBehaviors.Behavior currentBehavior = BehaviorUtils.getCurrentBehavior((LivingEntityPatch)this);
        if (!(currentBehavior == null || (name = currentBehavior.getBehaviorRoot().getRootName()) != null && name.equals("ArteriusDashing"))) {
            this.dealStaminaDamage(null, (float)(((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get()) * (double)0.012f));
        }
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        boolean applied;
        Arterius arterius = (Arterius)this.getOriginal();
        if (arterius.getInvulnerableTimer() > 0) {
            return false;
        }
        if (stunTime > 0.5f) {
            stunTime = 0.5f;
        }
        if ((applied = super.applyStun(stunType, stunTime)) && stunType != StunType.NEUTRALIZE && stunType != StunType.NONE) {
            ++this.stunLevel;
            this.lastStunTime = ((PathfinderMob)this.original).f_19797_;
            if (this.stunLevel >= 3) {
                double percent = Mth.m_14008_((double)(0.25 * (double)(this.stunLevel - 2)), (double)0.0, (double)1.0);
                double random = Math.random();
                if (random < percent) {
                    ((PathfinderMob)this.original).m_147215_(new MobEffectInstance((MobEffect)CEMobEffects.FULL_STUN_IMMUNITY.get(), (this.stunLevel - 2) * 80), this.original);
                    if (!this.isLogicalClient()) {
                        this.playAnimationSynchronized((AssetAccessor)EFNDodgeAnimations.DODGE_ROLL_B, 0.0f, SPAnimatorControl::new);
                    }
                    this.stunLevel = 0;
                }
            }
        }
        return applied;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = ((PathfinderMob)this.original).m_6134_();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }

    public boolean canBeExecuted(LivingEntityPatch<?> entityPatch) {
        return ((Arterius)this.original).isInBattle();
    }

    public ExecutionTypeManager.Type getExecutionType() {
        return ExecutionTypeManager.DEFAULT_TYPE;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: 
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.BIPED_KNOCKDOWN;
            }
            case NEUTRALIZE: {
                return Animations.GREATSWORD_GUARD_BREAK;
            }
            case FALL: {
                return Animations.BIPED_LANDING;
            }
        }
        return null;
    }
}

