/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.entity.spear_knight;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.nightfall_invade.config.boss.BossConfig;
import net.shelmarow.nightfall_invade.effect.NFIMobEffects;
import net.shelmarow.nightfall_invade.entity.spear_knight.Arterius;

@Mod.EventBusSubscriber(modid="nightfall_invade", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArteriusBossEvents {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Arterius) {
            for (ItemEntity drop : event.getDrops()) {
                drop.m_146915_(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity() instanceof ServerPlayer && !event.isCanceled() && (entity = event.getSource().m_7639_()) instanceof Arterius) {
            Arterius arterius = (Arterius)entity;
            arterius.resetBossStatus(true);
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntity();
        if (target instanceof Arterius) {
            event.setStrength(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        if (!source.m_269533_(DamageTypeTags.f_268738_) && target.m_6084_() && target instanceof Arterius) {
            Arterius arterius = (Arterius)target;
            if (!arterius.isInBattle()) {
                event.setCanceled(true);
            }
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                event.setCanceled(true);
            }
            if (arterius.getInvulnerableTimer() > 0) {
                int bossPhase = arterius.getBossPhase();
                if (bossPhase == 1 && arterius.m_21223_() < arterius.m_21233_() * 0.75f) {
                    arterius.m_21153_(arterius.m_21233_() * 0.75f);
                } else if (bossPhase == 2 && arterius.m_21223_() < arterius.m_21233_() * 0.5f) {
                    arterius.m_21153_(arterius.m_21233_() * 0.5f);
                } else if (bossPhase == 3 && arterius.m_21223_() < arterius.m_21233_() * 0.25f) {
                    arterius.m_21153_(arterius.m_21233_() * 0.25f);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        LivingEntity target = event.getEntity();
        Entity trueAttacker = source.m_7639_();
        if (trueAttacker instanceof Arterius && target instanceof LivingEntity) {
            LivingEntity livingTarget = target;
            int level = (Integer)BossConfig.ARTERIUS_DEBUFF_LEVEL.get();
            int duration = (Integer)BossConfig.ARTERIUS_DEBUFF_DURATION.get();
            float exBuffDamage = ((Double)BossConfig.ARTERIUS_DEBUFF_EX_DAMAGE.get()).floatValue();
            float exBuffHPDamage = ((Double)BossConfig.ARTERIUS_DEBUFF_EX_HP_DAMAGE.get()).floatValue();
            float exHPDamage = ((Double)BossConfig.ARTERIUS_EX_HP_DAMAGE.get()).floatValue();
            if (livingTarget.m_21023_((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get())) {
                damage *= 1.0f + exBuffDamage;
                damage += livingTarget.m_21233_() * exBuffHPDamage;
            }
            livingTarget.m_147215_(new MobEffectInstance((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get(), duration, level), (Entity)livingTarget);
            damage += livingTarget.m_21233_() * exHPDamage;
        }
        event.setAmount(damage);
    }

    @SubscribeEvent
    public static void onLivingHealEvent(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)NFIMobEffects.SOUL_OF_FLAME.get())) {
            event.setAmount(0.0f);
        }
    }
}

