/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.nightfall_invade.client.bossbar;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.combat_evolution.client.bossbar.ClientBossData;

@Mod.EventBusSubscriber(modid="nightfall_invade", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class BossBarRenderEvent {
    private static final ResourceLocation BOSS_BAR_HEALTH = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/bossbar/boss_bar_health.png");
    private static final ResourceLocation BOSS_BAR_STAMINA = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/bossbar/boss_bar_stamina.png");
    private static final ResourceLocation BOSS_BAR_BG = ResourceLocation.fromNamespaceAndPath((String)"nightfall_invade", (String)"textures/gui/bossbar/boss_bar_bg.png");

    @SubscribeEvent
    public static void onBossBarRender(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent boss = event.getBossEvent();
        ClientBossData.BossData bossData = ClientBossData.getBossData((UUID)boss.m_18860_());
        if (bossData.displayType.getString().equals("[NightFallInvade:Arterius]")) {
            event.setCanceled(true);
            Minecraft mc = Minecraft.m_91087_();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int x = event.getX();
            int y = event.getY();
            Component displayName = boss.m_18861_();
            float progress = Mth.m_14036_((float)boss.m_142717_(), (float)0.0f, (float)1.0f);
            float stamina = Mth.m_14036_((float)ClientBossData.getStaminaProgress((ClientBossData.BossData)bossData), (float)0.0f, (float)1.0f);
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280163_(BOSS_BAR_HEALTH, x + 91 - 128 + 13, y - 9, 13.0f, 0.0f, Math.round(230.0f * progress), 32, 256, 32);
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280163_(BOSS_BAR_STAMINA, x + 91 - 128 + 11, y - 9, 11.0f, 0.0f, Math.round(234.0f * stamina), 32, 256, 32);
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280163_(BOSS_BAR_BG, x + 91 - 128, y - 9, 0.0f, 0.0f, 256, 32, 256, 32);
            Font font = mc.f_91062_;
            int n = x + 91 - mc.f_91062_.m_92852_((FormattedText)displayName) / 2;
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280614_(font, displayName, n, y - 9 + 23, 0xFFFFFF, false);
            Objects.requireNonNull(mc.f_91062_);
            event.setIncrement(48 - 9);
        }
    }
}

