/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SurvivalBeltEvents {
    private static boolean hasSurvivalBelt(Player p) {
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SURVIVAL_BELT.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent
    public static void onLooting(LootingLevelEvent e) {
        Entity direct;
        LivingEntity victim = e.getEntity();
        if (!(victim instanceof Animal)) {
            return;
        }
        if (!(victim.m_9236_() instanceof ServerLevel)) {
            return;
        }
        DamageSource src = e.getDamageSource();
        if (src == null) {
            return;
        }
        Entity attackerEnt = src.m_7639_();
        if (attackerEnt == null && (direct = src.m_7640_()) instanceof Projectile) {
            Projectile proj = (Projectile)direct;
            attackerEnt = proj.m_19749_();
        }
        if (!(attackerEnt instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)attackerEnt;
        boolean hasBelt = CuriosApi.getCuriosInventory((LivingEntity)attacker).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SURVIVAL_BELT.get())).isEmpty()).orElse(false);
        if (!hasBelt) {
            return;
        }
        e.setLootingLevel(e.getLootingLevel() + 2);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        Player p = e.getEntity();
        Level level = e.getLevel();
        if (p == null || level.f_46443_) {
            return;
        }
        if (!SurvivalBeltEvents.hasSurvivalBelt(p)) {
            return;
        }
        if (!p.m_6144_()) {
            return;
        }
        if (!p.m_21205_().m_41619_()) {
            return;
        }
        BlockPos placePos = e.getPos().m_121945_(e.getFace());
        if (!level.m_8055_(placePos).m_60795_()) {
            return;
        }
        if (!BaseFireBlock.m_49255_((Level)level, (BlockPos)placePos, (Direction)e.getFace())) {
            return;
        }
        BlockState fire = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)placePos);
        if (fire == null || fire.m_60795_()) {
            fire = Blocks.f_50083_.m_49966_();
        }
        level.m_7731_(placePos, fire, 11);
        level.m_5594_(null, placePos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.4f + 0.8f);
        e.setCancellationResult(InteractionResult.SUCCESS);
        e.setCanceled(true);
    }
}

