/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StillBeatingHeartEvents {
    private static boolean hasHeart(LivingEntity e) {
        return CuriosApi.getCuriosInventory((LivingEntity)e).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.STILL_BEATING_HEART.get())).isEmpty()).orElse(false);
    }

    private static LivingEntity resolveAttacker(DamageSource src) {
        Projectile proj;
        Entity owner;
        Entity ts = src.m_7639_();
        Entity direct = src.m_7640_();
        LivingEntity atk = null;
        if (ts instanceof LivingEntity) {
            LivingEntity le;
            atk = le = (LivingEntity)ts;
        }
        if (atk == null && direct instanceof LivingEntity) {
            LivingEntity le2;
            atk = le2 = (LivingEntity)direct;
        }
        if (direct instanceof Projectile && (owner = (proj = (Projectile)direct).m_19749_()) instanceof LivingEntity) {
            LivingEntity le3;
            atk = le3 = (LivingEntity)owner;
        }
        return atk;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onLivingHurt(LivingHurtEvent e) {
        float max;
        if (e.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity attacker = StillBeatingHeartEvents.resolveAttacker(e.getSource());
        if (attacker == null || !attacker.m_6084_() || attacker.m_5833_()) {
            return;
        }
        if (!StillBeatingHeartEvents.hasHeart(attacker)) {
            return;
        }
        float hp = attacker.m_21223_();
        if (hp + 1.0E-4f < (max = attacker.m_21233_())) {
            return;
        }
        float base = e.getAmount();
        e.setAmount(base * 1.2f);
    }
}

