/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RustyGuillotineBladeEvents {
    private static final double THRESHOLD = 0.4;
    private static final double BONUS = 0.8;

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onLivingHurt(LivingHurtEvent e) {
        if (e.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity victim = e.getEntity();
        if (victim == null || !victim.m_6084_()) {
            return;
        }
        double max = victim.m_21233_();
        if (max <= 0.0) {
            return;
        }
        double ratio = (double)victim.m_21223_() / max;
        if (ratio > 0.4) {
            return;
        }
        LivingEntity attacker = RustyGuillotineBladeEvents.resolveAttacker(e.getSource());
        if (attacker == null || !attacker.m_6084_() || attacker.m_5833_()) {
            return;
        }
        boolean equipped = CuriosApi.getCuriosInventory((LivingEntity)attacker).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.RUSTY_GUILLOTINE_BLADE.get())).isEmpty()).orElse(false);
        if (!equipped) {
            return;
        }
        float base = e.getAmount();
        if (base <= 0.0f) {
            return;
        }
        e.setAmount((float)((double)base * 1.8));
    }

    private static LivingEntity resolveAttacker(DamageSource src) {
        Projectile proj;
        Entity entity;
        Entity direct = src.m_7640_();
        Entity cause = src.m_7639_();
        LivingEntity attacker = null;
        if (cause instanceof LivingEntity) {
            LivingEntity le;
            attacker = le = (LivingEntity)cause;
        } else if (direct instanceof LivingEntity) {
            LivingEntity le2;
            attacker = le2 = (LivingEntity)direct;
        }
        if (direct instanceof Projectile && (entity = (proj = (Projectile)direct).m_19749_()) instanceof LivingEntity) {
            LivingEntity le3;
            attacker = le3 = (LivingEntity)entity;
        }
        return attacker;
    }
}

