/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import java.util.List;
import java.util.UUID;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoseOfTemptationEvents {
    private static final double LURE_RADIUS = 16.0;
    private static final int TICK_INTERVAL = 1;
    private static final int MOB_COOLDOWN = 1;
    private static final String TAG_CD = "ua_rose_tempt_cd";
    private static final double BASE_GROUND_DEFAULT = 0.22;
    private static final double BASE_GROUND_FROG = 0.28;
    private static final double BASE_FLY_BEE = 0.45;
    private static final UUID UUID_SPEED_UNIFY = UUID.fromString("2a1a7b8c-01d2-4a73-9b37-5b1f98750001");
    private static final UUID UUID_FLYSPD_UNIFY = UUID.fromString("2a1a7b8c-01d2-4a73-9b37-5b1f98750002");
    private static final String TAG_ROSE_DECEL_ONCE = "ua_rose_decel_once";
    private static final String TAG_ROSE_APPLIED_UNTIL = "ua_rose_applied_until";
    private static final int APPLY_TTL = 2;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        Level lvl = p.m_9236_();
        if (lvl.f_46443_) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)lvl;
        if (!p.m_6084_() || p.m_5833_()) {
            return;
        }
        RoseOfTemptationEvents.cleanupAroundPlayer(sl, p, 32.0);
        if (p.f_19797_ % 1 != 0) {
            return;
        }
        boolean active = RoseOfTemptationEvents.isHoldingOrEquipped(p);
        if (!active) {
            RoseOfTemptationEvents.releaseInfluencedMobs(sl, p, 24.0);
            return;
        }
        AABB box = p.m_20191_().m_82400_(16.0);
        List mobs = sl.m_6443_(Mob.class, box, m -> RoseOfTemptationEvents.isLurable(m, p));
        long now = sl.m_46467_();
        for (Mob m2 : mobs) {
            Wolf w;
            long next = m2.getPersistentData().m_128454_(TAG_CD);
            if (now < next) continue;
            m2.getPersistentData().m_128356_(TAG_CD, now + 1L);
            if (m2 instanceof Wolf && (w = (Wolf)m2).m_21824_() && w.m_21825_()) continue;
            m2.m_21563_().m_24960_((Entity)p, 25.0f, 25.0f);
            RoseOfTemptationEvents.applyUniformSpeedWithTTL(m2, now);
            if (m2.m_21573_() == null) continue;
            double d2 = m2.m_20280_((Entity)p);
            if (d2 > 2.25) {
                m2.m_21573_().m_5624_((Entity)p, 1.1);
                continue;
            }
            m2.m_21573_().m_26573_();
        }
    }

    @SubscribeEvent
    public static void onAnyLivingTick(LivingEvent.LivingTickEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob m = (Mob)livingEntity;
        if (m.m_9236_().f_46443_) {
            return;
        }
        long now = ((ServerLevel)m.m_9236_()).m_46467_();
        CompoundTag pd = m.getPersistentData();
        long until = pd.m_128454_(TAG_ROSE_APPLIED_UNTIL);
        if (until <= 0L) {
            pd.m_128473_(TAG_ROSE_DECEL_ONCE);
            return;
        }
        if (now > until) {
            RoseOfTemptationEvents.clearUniformSpeed(m);
            pd.m_128473_(TAG_ROSE_APPLIED_UNTIL);
            if (!pd.m_128471_(TAG_ROSE_DECEL_ONCE)) {
                Vec3 dm = m.m_20184_();
                m.m_20334_(dm.f_82479_ * 0.3, dm.f_82480_, dm.f_82481_ * 0.3);
                m.m_6858_(false);
                if (m.m_21573_() != null && m.m_21573_().m_26572_()) {
                    m.m_21573_().m_26573_();
                }
                pd.m_128379_(TAG_ROSE_DECEL_ONCE, true);
            }
        } else {
            pd.m_128473_(TAG_ROSE_DECEL_ONCE);
        }
    }

    private static void releaseInfluencedMobs(ServerLevel sl, Player p, double radius) {
        long now = sl.m_46467_();
        AABB box = p.m_20191_().m_82400_(radius);
        for (Mob m : sl.m_45976_(Mob.class, box)) {
            long until = m.getPersistentData().m_128454_(TAG_ROSE_APPLIED_UNTIL);
            if (until <= 0L) continue;
            RoseOfTemptationEvents.clearUniformSpeed(m);
            m.getPersistentData().m_128473_(TAG_ROSE_APPLIED_UNTIL);
            m.getPersistentData().m_128473_(TAG_CD);
            if (m.m_21573_() != null && m.m_21573_().m_26572_()) {
                m.m_21573_().m_26573_();
            }
            Vec3 dm = m.m_20184_();
            m.m_20334_(dm.f_82479_ * 0.3, dm.f_82480_, dm.f_82481_ * 0.3);
            m.m_6858_(false);
        }
    }

    private static boolean isHoldingOrEquipped(Player p) {
        boolean holding = p.m_21205_().m_150930_((Item)UAItems.ROSE_OF_TEMPTATION.get()) || p.m_21206_().m_150930_((Item)UAItems.ROSE_OF_TEMPTATION.get());
        boolean equipped = CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.ROSE_OF_TEMPTATION.get())).isEmpty()).orElse(false);
        return holding || equipped;
    }

    private static boolean isLurable(Mob m, Player owner) {
        if (!m.m_6084_() || m.m_213877_()) {
            return false;
        }
        if (m instanceof Frog) {
            return false;
        }
        if (m instanceof PiglinBrute) {
            return false;
        }
        if (m instanceof Piglin) {
            Piglin piglin = (Piglin)m;
            Brain brain = piglin.m_6274_();
            if (m.m_5448_() != null) {
                return false;
            }
            if (brain.m_21874_(MemoryModuleType.f_26372_)) {
                return false;
            }
            if (brain.m_21874_(MemoryModuleType.f_26334_)) {
                return false;
            }
            if (brain.m_21874_(MemoryModuleType.f_26383_)) {
                return false;
            }
            if (brain.m_21874_(MemoryModuleType.f_26336_)) {
                return false;
            }
            return !brain.m_21874_(MemoryModuleType.f_26341_);
        }
        if (m instanceof ZombifiedPiglin) {
            ZombifiedPiglin zp = (ZombifiedPiglin)m;
            if (zp.m_5448_() != null) {
                return false;
            }
            return !zp.m_6274_().m_21874_(MemoryModuleType.f_26334_);
        }
        if (m.m_6095_().m_20674_() == MobCategory.MONSTER) {
            return false;
        }
        if (m instanceof Wolf) {
            Wolf w = (Wolf)m;
            if (w.m_21660_() || w.m_5448_() != null) {
                return false;
            }
            if (w.m_21824_()) {
                if (w.m_21825_()) {
                    return false;
                }
                return w.m_21830_((LivingEntity)owner);
            }
            return true;
        }
        if (m instanceof Bee) {
            Bee b = (Bee)m;
            return !b.m_21660_() && b.m_5448_() == null;
        }
        return m instanceof PathfinderMob && m.m_5448_() == null;
    }

    private static void applyUniformSpeedWithTTL(Mob m, long now) {
        if (m instanceof Allay) {
            return;
        }
        AttributeInstance ms = m.m_21051_(Attributes.f_22279_);
        if (ms != null) {
            double add;
            double target = m instanceof Frog ? 0.28 : 0.22;
            AttributeModifier old = ms.m_22111_(UUID_SPEED_UNIFY);
            if (old != null) {
                ms.m_22130_(old);
            }
            if (Math.abs(add = target - ms.m_22115_()) > 1.0E-6) {
                ms.m_22118_(new AttributeModifier(UUID_SPEED_UNIFY, "ua.rose.uniform_ground", add, AttributeModifier.Operation.ADDITION));
            }
        }
        if (m instanceof Bee) {
            AttributeInstance fs = m.m_21051_(Attributes.f_22280_);
            if (fs != null) {
                double addF;
                AttributeModifier oldF = fs.m_22111_(UUID_FLYSPD_UNIFY);
                if (oldF != null) {
                    fs.m_22130_(oldF);
                }
                if (Math.abs(addF = 0.45 - fs.m_22115_()) > 1.0E-6) {
                    fs.m_22118_(new AttributeModifier(UUID_FLYSPD_UNIFY, "ua.rose.uniform_fly", addF, AttributeModifier.Operation.ADDITION));
                }
            }
        } else {
            AttributeModifier oldF;
            AttributeInstance fs = m.m_21051_(Attributes.f_22280_);
            if (fs != null && (oldF = fs.m_22111_(UUID_FLYSPD_UNIFY)) != null) {
                fs.m_22130_(oldF);
            }
        }
        m.getPersistentData().m_128356_(TAG_ROSE_APPLIED_UNTIL, now + 2L);
    }

    private static void clearUniformSpeed(Mob m) {
        AttributeModifier oldF;
        AttributeInstance fs;
        AttributeModifier old;
        AttributeInstance ms = m.m_21051_(Attributes.f_22279_);
        if (ms != null && (old = ms.m_22111_(UUID_SPEED_UNIFY)) != null) {
            ms.m_22130_(old);
        }
        if ((fs = m.m_21051_(Attributes.f_22280_)) != null && (oldF = fs.m_22111_(UUID_FLYSPD_UNIFY)) != null) {
            fs.m_22130_(oldF);
        }
    }

    private static void cleanupAroundPlayer(ServerLevel sl, Player p, double radius) {
        long now = sl.m_46467_();
        AABB box = p.m_20191_().m_82400_(radius);
        boolean active = RoseOfTemptationEvents.isHoldingOrEquipped(p);
        for (Mob m : sl.m_45976_(Mob.class, box)) {
            long until = m.getPersistentData().m_128454_(TAG_ROSE_APPLIED_UNTIL);
            if (until > 0L && now > until) {
                RoseOfTemptationEvents.clearUniformSpeed(m);
                m.getPersistentData().m_128473_(TAG_ROSE_APPLIED_UNTIL);
            }
            if (active) continue;
        }
    }
}

