/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BloodyKnifeEvents {
    @SubscribeEvent
    public static void onHurt(LivingHurtEvent e) {
        LivingEntity victim = e.getEntity();
        if (victim.m_9236_().f_46443_) {
            return;
        }
        Player attacker = BloodyKnifeEvents.resolvePlayerAttacker(e);
        if (attacker == null || !attacker.m_6084_() || attacker.m_5833_()) {
            return;
        }
        boolean hasKnife = CuriosApi.getCuriosInventory((LivingEntity)attacker).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.BLOODY_KNIFE.get())).isEmpty()).orElse(false);
        if (!hasKnife) {
            return;
        }
        if (!BloodyKnifeEvents.isBehind(victim, e)) {
            return;
        }
        double bonus = 0.3;
        if (bonus <= 0.0) {
            return;
        }
        e.setAmount((float)((double)e.getAmount() * (1.0 + bonus)));
    }

    private static Player resolvePlayerAttacker(LivingHurtEvent e) {
        Projectile proj;
        Entity entity;
        Entity src = e.getSource().m_7639_();
        Entity direct = e.getSource().m_7640_();
        if (direct instanceof Projectile && (entity = (proj = (Projectile)direct).m_19749_()) instanceof Player) {
            Player p = (Player)entity;
            return p;
        }
        if (src instanceof Player) {
            Player p = (Player)src;
            return p;
        }
        return null;
    }

    private static boolean isBehind(LivingEntity victim, LivingHurtEvent e) {
        double thr;
        Vec3 vf = victim.m_20252_(1.0f);
        vf = new Vec3(vf.f_82479_, 0.0, vf.f_82481_);
        if (vf.m_82556_() < 1.0E-6) {
            return false;
        }
        vf = vf.m_82541_();
        Vec3 targetPos = null;
        Entity direct = e.getSource().m_7640_();
        if (direct != null) {
            targetPos = direct.m_20182_();
        } else if (e.getSource().m_7639_() != null) {
            targetPos = e.getSource().m_7639_().m_20182_();
        }
        if (targetPos == null) {
            return false;
        }
        Vec3 dir = new Vec3(targetPos.f_82479_ - victim.m_20185_(), 0.0, targetPos.f_82481_ - victim.m_20189_());
        if (dir.m_82556_() < 1.0E-6) {
            return false;
        }
        double dot = vf.m_82526_(dir = dir.m_82541_());
        return dot <= (thr = -0.5);
    }
}

