/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BladeShoesEvents {
    private static boolean hasBladeShoes(Player p) {
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.BLADE_SHOES.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        if (p.m_9236_().f_46443_) {
            return;
        }
        if (!p.m_6084_() || p.m_5833_()) {
            return;
        }
        if (!BladeShoesEvents.hasBladeShoes(p)) {
            return;
        }
        ServerLevel level = (ServerLevel)p.m_9236_();
        AABB bb = p.m_20191_();
        int y0 = Mth.m_14107_((double)bb.f_82289_);
        int minX = Mth.m_14107_((double)bb.f_82288_);
        int maxX = Mth.m_14107_((double)bb.f_82291_);
        int minZ = Mth.m_14107_((double)bb.f_82290_);
        int maxZ = Mth.m_14107_((double)bb.f_82293_);
        int broken = 0;
        int limitPerTick = 6;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                BlockState upperSt;
                BlockPos upperPos;
                if (broken >= limitPerTick) {
                    return;
                }
                BlockPos floorPos = new BlockPos(x, y0, z);
                BlockState floorSt = level.m_8055_(floorPos);
                if (BladeShoesEvents.isShreddableAtFeet(level, floorPos, floorSt)) {
                    level.m_46953_(floorPos, true, (Entity)p);
                    if (++broken >= limitPerTick) {
                        return;
                    }
                }
                if (!BladeShoesEvents.isLowFloor(level, floorPos, floorSt) || !BladeShoesEvents.isShreddableAtFeet(level, upperPos = floorPos.m_7494_(), upperSt = level.m_8055_(upperPos))) continue;
                level.m_46953_(upperPos, true, (Entity)p);
                if (++broken < limitPerTick) continue;
                return;
            }
        }
    }

    private static boolean isShreddableAtFeet(ServerLevel level, BlockPos pos, BlockState st) {
        if (st.m_60795_()) {
            return false;
        }
        if (!st.m_60819_().m_76178_()) {
            return false;
        }
        if (st.m_60713_(Blocks.f_152480_)) {
            return false;
        }
        if (st.m_60713_(Blocks.f_50033_)) {
            return true;
        }
        if (st.m_204336_(BlockTags.f_13073_)) {
            return true;
        }
        if (st.m_204336_(BlockTags.f_13037_) || st.m_204336_(BlockTags.f_13040_)) {
            return true;
        }
        if (st.m_60713_(Blocks.f_50130_) || st.m_60713_(Blocks.f_50570_)) {
            return true;
        }
        if (st.m_60713_(Blocks.f_50191_)) {
            return true;
        }
        if (st.m_60713_(Blocks.f_50685_)) {
            return true;
        }
        return st.m_60812_((BlockGetter)level, pos).m_83281_() && st.m_247087_();
    }

    private static boolean isLowFloor(ServerLevel level, BlockPos pos, BlockState st) {
        if (st.m_60795_()) {
            return false;
        }
        if (st.m_60713_(Blocks.f_50093_)) {
            return true;
        }
        VoxelShape shape = st.m_60812_((BlockGetter)level, pos);
        if (shape.m_83281_()) {
            return false;
        }
        AABB aabb = shape.m_83215_();
        double height = aabb.f_82292_ - aabb.f_82289_;
        return height < 0.99;
    }
}

