/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.loot;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoyalHoneycombDrops {
    private static final float CHANCE = 0.01f;

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        Level level = e.getLevel();
        if (level.f_46443_) {
            return;
        }
        if (e.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!RoyalHoneycombDrops.isShearingFullHive(level, e.getPos(), e.getItemStack())) {
            return;
        }
        if (!RoyalHoneycombDrops.chance(level, 0.01f)) {
            return;
        }
        RoyalHoneycombDrops.dropItemAt((ServerLevel)level, e.getPos(), new ItemStack((ItemLike)UAItems.ROYAL_HONEYCOMB.get()));
    }

    private static boolean isShearingFullHive(Level level, BlockPos pos, ItemStack used) {
        if (!(used.m_41720_() instanceof ShearsItem)) {
            return false;
        }
        BlockState st = level.m_8055_(pos);
        if (!(st.m_60734_() instanceof BeehiveBlock)) {
            return false;
        }
        return st.m_61138_((Property)BeehiveBlock.f_49564_) && (Integer)st.m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
    }

    private static boolean chance(Level level, float p) {
        return level.m_213780_().m_188501_() < p;
    }

    private static void dropItemAt(ServerLevel sl, BlockPos pos, ItemStack stack) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        ItemEntity ie = new ItemEntity((Level)sl, x, y, z, stack);
        sl.m_7967_((Entity)ie);
    }
}

