/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.advancement;

import java.util.HashSet;
import java.util.Set;
import net.genzyuro.uniqueaccessories.advancement.UACriteria;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AccessoryCollectTracker {
    private static final String TAG_SET = "ua_accessory_types_seen";
    private static final ResourceLocation ACCESSORY_TAG = new ResourceLocation("uniqueaccessories", "accessories");

    private static Set<String> load(Player p) {
        CompoundTag pd = p.getPersistentData();
        HashSet<String> s = new HashSet<String>();
        if (pd.m_128441_(TAG_SET)) {
            CompoundTag t = pd.m_128469_(TAG_SET);
            for (String k : t.m_128431_()) {
                if (!t.m_128471_(k)) continue;
                s.add(k);
            }
        }
        return s;
    }

    private static void save(Player p, Set<String> s) {
        CompoundTag t = new CompoundTag();
        for (String id : s) {
            t.m_128379_(id, true);
        }
        p.getPersistentData().m_128365_(TAG_SET, (Tag)t);
    }

    private static boolean isAccessory(ItemStack st) {
        return st.m_204117_(ItemTags.create((ResourceLocation)ACCESSORY_TAG));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = e.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (sp.f_19797_ % 20 != 0) {
            return;
        }
        int count = AccessoryCollectTracker.scanAndUpdate(sp);
        UACriteria.ACCESSORY_TYPES_COLLECTED.trigger(sp, count);
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        int count = AccessoryCollectTracker.scanAndUpdate(sp);
        UACriteria.ACCESSORY_TYPES_COLLECTED.trigger(sp, count);
    }

    private static int scanAndUpdate(ServerPlayer sp) {
        Set<String> seen = AccessoryCollectTracker.load((Player)sp);
        for (ItemStack st : sp.m_150109_().f_35974_) {
            AccessoryCollectTracker.addIfAccessory(seen, st);
        }
        for (ItemStack st : sp.m_150109_().f_35976_) {
            AccessoryCollectTracker.addIfAccessory(seen, st);
        }
        for (ItemStack st : sp.m_150109_().f_35975_) {
            AccessoryCollectTracker.addIfAccessory(seen, st);
        }
        int before = AccessoryCollectTracker.load((Player)sp).size();
        if (seen.size() != before) {
            AccessoryCollectTracker.save((Player)sp, seen);
        }
        return seen.size();
    }

    private static void addIfAccessory(Set<String> set, ItemStack st) {
        if (st.m_41619_()) {
            return;
        }
        if (!AccessoryCollectTracker.isAccessory(st)) {
            return;
        }
        ResourceLocation id = st.m_41720_().m_204114_().m_205785_().m_135782_();
        set.add(id.toString());
    }
}

