/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.bountiful_npc.dialog;

import com.p1nero.bountiful_npc.client.sound.BountifulNpcSounds;
import com.p1nero.bountiful_npc.villager.BountifulVillagers;
import com.p1nero.dialog_lib.api.entity.EntityDialogueExtension;
import com.p1nero.dialog_lib.api.entity.IEntityDialogueExtension;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import io.ejekta.bountiful.bounty.BountyData;
import io.ejekta.bountiful.content.BountifulContent;
import io.ejekta.bountiful.content.board.BoardBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@EntityDialogueExtension(modId="bountiful_npc")
public class ReceptionistDialogExtension
implements IEntityDialogueExtension<Villager> {
    public EntityType<Villager> getEntityType() {
        return EntityType.f_20492_;
    }

    public boolean canInteractWith(Player player, Villager currentTalking) {
        return currentTalking.m_7141_().m_35571_() == BountifulVillagers.RECEPTIONIST.get();
    }

    @Nullable
    public InteractionResult shouldCancelInteract(Player player, Villager currentTalking, InteractionHand hand) {
        return InteractionResult.SUCCESS;
    }

    public void onPlayerInteract(Player player, Villager currentTalking, InteractionHand hand) {
        super.onPlayerInteract(player, (Entity)currentTalking, hand);
        player.m_9236_().m_5594_(null, currentTalking.m_20097_(), (SoundEvent)BountifulNpcSounds.ON_RECEPTIONIST_INTERACT.get(), SoundSource.VOICE, 1.0f, 1.0f);
    }

    public CompoundTag getServerData(ServerPlayer player, Villager currentTalking, InteractionHand hand, CompoundTag senderData) {
        if (player.m_21205_().m_150930_(BountifulContent.INSTANCE.getBOUNTY_ITEM())) {
            senderData.m_128379_("isBounty", true);
        }
        if (player.m_21205_().m_150930_(BountifulContent.INSTANCE.getDECREE_ITEM())) {
            senderData.m_128379_("isDecree", true);
        }
        return senderData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogScreen(StreamDialogueScreenBuilder dialogueScreenBuilder, LocalPlayer localPlayer, Villager villager, CompoundTag serverData) {
        dialogueScreenBuilder.start((Component)Component.m_237115_((String)"dialog.minecraft.villager.bountiful_npc.1")).addFinalOption((Component)Component.m_237115_((String)"option.minecraft.villager.bountiful_npc.1"), 1);
        if (serverData.m_128471_("isBounty")) {
            dialogueScreenBuilder.addFinalOption((Component)Component.m_237115_((String)"option.minecraft.villager.bountiful_npc.2").m_130940_(ChatFormatting.GREEN), 2);
        }
        if (serverData.m_128471_("isDecree")) {
            dialogueScreenBuilder.addFinalOption((Component)Component.m_237115_((String)"option.minecraft.villager.bountiful_npc.2").m_130940_(ChatFormatting.GREEN), 1);
        }
        return dialogueScreenBuilder.build();
    }

    public void handleNpcInteraction(Villager villager, ServerPlayer serverPlayer, int i) {
        villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).ifPresent(globalPos -> {
            MenuProvider screenHandlerFactory;
            if (globalPos.m_122640_() != villager.m_9236_().m_46472_()) {
                return;
            }
            Level level = villager.m_9236_();
            BlockPos jobSitePos = globalPos.m_122646_();
            if (i == 1 && (screenHandlerFactory = serverPlayer.m_284548_().m_8055_(jobSitePos).m_60750_(level, jobSitePos)) != null) {
                serverPlayer.m_5893_(screenHandlerFactory);
            }
            if (i == 2) {
                BlockEntity patt5295$temp;
                ItemStack holding = serverPlayer.m_21205_();
                if (!holding.m_150930_(BountifulContent.INSTANCE.getBOUNTY_ITEM())) {
                    holding = serverPlayer.m_21206_();
                }
                if (!holding.m_150930_(BountifulContent.INSTANCE.getBOUNTY_ITEM())) {
                    return;
                }
                BountyData data = (BountyData)BountyData.Companion.get(holding);
                if (data.tryCashIn((Player)serverPlayer, holding) && (patt5295$temp = level.m_7702_(jobSitePos)) instanceof BoardBlockEntity) {
                    BoardBlockEntity bountyEntity = (BoardBlockEntity)patt5295$temp;
                    bountyEntity.updateCompletedBounties((Player)serverPlayer);
                    bountyEntity.m_6596_();
                }
            }
        });
        this.removeConservingPlayer((Entity)villager);
    }
}

