/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.bountiful_npc.datagen.sound;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.registries.RegistryObject;

public abstract class BNSoundProvider
extends SoundDefinitionsProvider {
    protected BNSoundProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "bountiful_npc", helper);
    }

    public void generateNewSoundWithSubtitle(RegistryObject<SoundEvent> event, String baseSoundDirectory, int numberOfSounds) {
        this.generateNewSound(event, baseSoundDirectory, numberOfSounds, true);
    }

    public void generateNewSound(RegistryObject<SoundEvent> event, String baseSoundDirectory, int numberOfSounds, boolean subtitle) {
        SoundDefinition definition = SoundDefinition.definition();
        if (subtitle) {
            String[] splitSoundName = event.getId().m_135815_().split("\\.", 3);
            definition.subtitle("subtitles.bountiful_npc." + splitSoundName[0] + "." + splitSoundName[2]);
        }
        for (int i = 1; i <= numberOfSounds; ++i) {
            definition.with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bountiful_npc", (String)(baseSoundDirectory + (String)(numberOfSounds > 1 ? "_" + i : ""))), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND));
        }
        this.add((Supplier)event, definition);
    }

    public void generateNewSoundMC(RegistryObject<SoundEvent> event, String baseSoundDirectory, int numberOfSounds, boolean subtitle) {
        SoundDefinition definition = SoundDefinition.definition();
        if (subtitle) {
            String[] splitSoundName = event.getId().m_135815_().split("\\.", 3);
            definition.subtitle("subtitles.bountiful_npc." + splitSoundName[0] + "." + splitSoundName[2]);
        }
        for (int i = 1; i <= numberOfSounds; ++i) {
            definition.with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.parse((String)(baseSoundDirectory + String.valueOf(numberOfSounds > 1 ? Integer.valueOf(i) : ""))), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND));
        }
        this.add((Supplier)event, definition);
    }

    public void generateExistingSoundWithSubtitle(RegistryObject<SoundEvent> event, SoundEvent referencedSound) {
        this.generateExistingSound(event, referencedSound, true);
    }

    public void generateSoundWithCustomSubtitle(RegistryObject<SoundEvent> event, SoundEvent referencedSound, String subtitle) {
        this.add((Supplier)event, SoundDefinition.definition().subtitle(subtitle).with(SoundDefinition.Sound.sound((ResourceLocation)referencedSound.m_11660_(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT)));
    }

    public void generateExistingSound(RegistryObject<SoundEvent> event, SoundEvent referencedSound, boolean subtitle) {
        SoundDefinition definition = SoundDefinition.definition();
        if (subtitle) {
            String[] splitSoundName = event.getId().m_135815_().split("\\.", 3);
            definition.subtitle("subtitles.bountiful_npc." + splitSoundName[0] + "." + splitSoundName[2]);
        }
        this.add((Supplier)event, definition.with(SoundDefinition.Sound.sound((ResourceLocation)referencedSound.m_11660_(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT)));
    }

    public void makeStepSound(RegistryObject<SoundEvent> event, SoundEvent referencedSound) {
        this.add((Supplier)event, SoundDefinition.definition().subtitle("subtitles.block.generic.footsteps").with(SoundDefinition.Sound.sound((ResourceLocation)referencedSound.m_11660_(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT)));
    }

    public void makeMusicDisc(RegistryObject<SoundEvent> event, String discName) {
        this.add((Supplier)event, SoundDefinition.definition().with(SoundDefinition.Sound.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bountiful_npc", (String)("music/" + discName)), (SoundDefinition.SoundType)SoundDefinition.SoundType.SOUND).stream()));
    }

    public void generateParrotSound(RegistryObject<SoundEvent> event, SoundEvent referencedSound) {
        SoundDefinition definition = SoundDefinition.definition();
        String[] splitSoundName = event.getId().m_135815_().split("\\.", 3);
        definition.subtitle("subtitles.bountiful_npc." + splitSoundName[0] + "." + splitSoundName[2]);
        this.add((Supplier)event, definition.with(SoundDefinition.Sound.sound((ResourceLocation)referencedSound.m_11660_(), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT).pitch(1.8f).volume(0.6f)));
    }
}

