/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.fast_tpa.network.packet.server;

import com.p1nero.fast_tpa.FastTPA;
import com.p1nero.fast_tpa.config.ServerConfig;
import com.p1nero.fast_tpa.network.packet.BasePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record SOSPacket(Component component) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130083_(this.component);
    }

    public static SOSPacket decode(FriendlyByteBuf buf) {
        return new SOSPacket(buf.m_130238_());
    }

    @Override
    public void execute(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer self = (ServerPlayer)player;
            int lastSendTime = self.getPersistentData().m_128451_("last_send_time");
            int left = (Integer)ServerConfig.COOLDOWN.get() - (self.f_19797_ - lastSendTime);
            if (lastSendTime != 0 && left > 0) {
                self.m_5661_((Component)Component.m_237110_((String)"info.fast_tpa.cooldown", (Object[])new Object[]{left / 20}).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), false);
                return;
            }
            MutableComponent formattedMessage = FastTPA.getFormattedName((Player)self).m_7220_(this.component);
            for (ServerPlayer target : self.m_284548_().m_7654_().m_6846_().m_11314_()) {
                if (target == self) continue;
                target.m_5661_((Component)formattedMessage, false);
                MutableComponent accept = Component.m_237115_((String)"info.fast_tpa.accept");
                accept.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN).m_131136_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/fast_tpa_tp " + target.m_6302_() + " " + self.m_6302_())));
                target.m_5661_((Component)accept, false);
                target.getPersistentData().m_128379_("accepted", false);
                target.getPersistentData().m_128379_("can_accept", true);
            }
            self.m_5661_((Component)formattedMessage, false);
            ServerLevel level = self.m_284548_();
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity((Level)level, (Entity)self, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42688_));
            level.m_7967_((Entity)fireworkrocketentity);
            self.getPersistentData().m_128405_("last_send_time", self.f_19797_);
        }
    }
}

