/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.block.zipline;

import com.alrex.parcool.common.block.BlockStateProperties;
import com.alrex.parcool.common.block.zipline.ZiplineHookBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronZiplineHookBlock
extends ZiplineHookBlock {
    public static final BooleanProperty ORTHOGONAL = BlockStateProperties.ORTHOGONAL;
    protected static final VoxelShape[] SHAPES = new VoxelShape[Direction.values().length];

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)f_52588_)).ordinal()];
    }

    public IronZiplineHookBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ORTHOGONAL, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Vec3 getActualZiplinePoint(BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_52588_);
        return new Vec3((double)pos.m_123341_() + 0.5 - (double)direction.m_122429_() * 0.2, (double)pos.m_123342_() + 0.5 - (double)direction.m_122430_() * 0.2, (double)pos.m_123343_() + 0.5 - (double)direction.m_122431_() * 0.2);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{ORTHOGONAL});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean orthogonal;
        BlockState state = super.m_5573_(context);
        Player player = context.m_43723_();
        if (player == null) {
            orthogonal = false;
        } else {
            Vec3 lookVec = player.m_20154_();
            switch (context.m_43719_()) {
                case NORTH: 
                case SOUTH: {
                    orthogonal = Math.abs(lookVec.m_7098_()) < Math.abs(lookVec.m_7096_());
                    break;
                }
                case EAST: 
                case WEST: {
                    orthogonal = Math.abs(lookVec.m_7098_()) < Math.abs(lookVec.m_7094_());
                    break;
                }
                default: {
                    orthogonal = Math.abs(lookVec.m_7094_()) < Math.abs(lookVec.m_7096_());
                }
            }
        }
        return (BlockState)state.m_61124_((Property)ORTHOGONAL, (Comparable)Boolean.valueOf(orthogonal));
    }

    static {
        IronZiplineHookBlock.SHAPES[Direction.DOWN.ordinal()] = Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        IronZiplineHookBlock.SHAPES[Direction.UP.ordinal()] = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0);
        IronZiplineHookBlock.SHAPES[Direction.SOUTH.ordinal()] = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)5.0);
        IronZiplineHookBlock.SHAPES[Direction.NORTH.ordinal()] = Block.m_49796_((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)16.0);
        IronZiplineHookBlock.SHAPES[Direction.WEST.ordinal()] = Block.m_49796_((double)11.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        IronZiplineHookBlock.SHAPES[Direction.EAST.ordinal()] = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0);
    }
}

