/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final int BASE_X = 5;
    private static final int HISTORY_X = 64;
    private static final int TITLE_COLOR = 0xFFFFFF;
    private static final int CONTENT_COLOR = 0xAAAAAA;

    @SubscribeEvent
    public void onRenderTick(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player;
        ItemStack stack;
        if (this.shouldRenderHUD() && this.isValidCompass(stack = ItemUtils.getHeldItem((Player)(player = ClientEventHandler.mc.f_91074_), ExplorersCompass.explorersCompass))) {
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.m_41720_();
            CompassState state = compass.getState(stack);
            if (state == CompassState.INACTIVE) {
                return;
            }
            this.renderMainState(event, compass, stack, (Player)player, state);
            if (((Boolean)ConfigHandler.CLIENT.showHaveFound.get()).booleanValue()) {
                this.renderSearchHistory(event, compass, stack);
            }
        }
    }

    private boolean shouldRenderHUD() {
        return ClientEventHandler.mc.f_91074_ != null && ClientEventHandler.mc.f_91073_ != null && !ClientEventHandler.mc.f_91066_.f_92062_ && !ClientEventHandler.mc.f_91066_.f_92063_ && (ClientEventHandler.mc.f_91080_ == null || (Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get() != false && ClientEventHandler.mc.f_91080_ instanceof ChatScreen);
    }

    private boolean isValidCompass(ItemStack stack) {
        return stack != null && stack.m_41720_() instanceof ExplorersCompassItem;
    }

    private void renderMainState(RenderGuiOverlayEvent.Post event, ExplorersCompassItem compass, ItemStack stack, Player player, CompassState state) {
        this.renderLinePair(event, "string.explorerscompass.status", I18n.m_118938_((String)this.getStatusKey(state), (Object[])new Object[0]), 0);
        this.renderLinePair(event, "string.explorerscompass.structure", StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 3);
        switch (state) {
            case SEARCHING: 
            case NOT_FOUND: {
                this.renderLinePair(event, "string.explorerscompass.radius", String.valueOf(compass.getSearchRadius(stack)), 6);
                break;
            }
            case FOUND: {
                if (!compass.shouldDisplayCoordinates(stack)) break;
                String coords = compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack);
                this.renderLinePair(event, "string.explorerscompass.coordinates", coords, 6);
                int distance = StructureUtils.getHorizontalDistanceToLocation(player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack));
                this.renderLinePair(event, "string.explorerscompass.distance", String.valueOf(distance), 9);
            }
        }
    }

    private void renderSearchHistory(RenderGuiOverlayEvent.Post event, ExplorersCompassItem compass, ItemStack stack) {
        int searchedTimes = compass.getSearchedTimes(stack);
        if (searchedTimes < 1) {
            return;
        }
        this.renderLine(event, I18n.m_118938_((String)"string.explorerscompass.have_searched", (Object[])new Object[0]), 64, 0, 0xFFFFFF);
        this.renderSearchRecord(event, compass, stack, 1, 1);
        if (searchedTimes >= 2) {
            this.renderSearchRecord(event, compass, stack, 2, 4);
        }
    }

    private void renderSearchRecord(RenderGuiOverlayEvent.Post event, ExplorersCompassItem compass, ItemStack stack, int recordId, int lineOffset) {
        ResourceLocation structureKey = recordId == 1 ? compass.getStructureKey1(stack) : compass.getStructureKey2(stack);
        boolean found = recordId == 1 ? compass.getSearchResult1(stack) : compass.getSearchResult2(stack);
        int xCoord = recordId == 1 ? compass.getFoundStructureX1(stack) : compass.getFoundStructureX2(stack);
        int zCoord = recordId == 1 ? compass.getFoundStructureZ1(stack) : compass.getFoundStructureZ2(stack);
        this.renderLine(event, StructureUtils.getPrettyStructureName(structureKey), 64, lineOffset, 0xAAAAAA);
        Object result = found ? xCoord + ", " + zCoord : I18n.m_118938_((String)"string.explorerscompass.notFound", (Object[])new Object[0]);
        this.renderLine(event, (String)result, 64, lineOffset + 1, 0xAAAAAA);
    }

    private void renderLinePair(RenderGuiOverlayEvent.Post event, String titleKey, String content, int startLine) {
        this.renderLine(event, I18n.m_118938_((String)titleKey, (Object[])new Object[0]), 5, startLine, 0xFFFFFF);
        this.renderLine(event, content, 5, startLine + 1, 0xAAAAAA);
    }

    private void renderLine(RenderGuiOverlayEvent.Post event, String text, int x, int line, int color) {
        RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), text, x, 5, color, line);
    }

    private String getStatusKey(CompassState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case CompassState.INACTIVE -> null;
            case CompassState.SEARCHING -> "string.explorerscompass.searching";
            case CompassState.FOUND -> "string.explorerscompass.found";
            case CompassState.NOT_FOUND -> "string.explorerscompass.notFound";
        };
    }
}

