/*
 * Decompiled with CFR 0.152.
 */
package com.mao.barbequesdelight.content.block;

import com.mao.barbequesdelight.content.block.BlockSlot;
import com.mao.barbequesdelight.content.block.GrillBlock;
import com.mao.barbequesdelight.content.block.GrillPlace;
import com.mao.barbequesdelight.content.recipe.GrillingRecipe;
import com.mao.barbequesdelight.init.data.BBQLangData;
import com.mao.barbequesdelight.init.registrate.BBQDItems;
import com.mao.barbequesdelight.init.registrate.BBQDRecipes;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;

@SerialClass
public class GrillBlockEntity
extends BaseBlockEntity
implements HeatableBlockEntity,
TickableBlockEntity,
BlockContainer,
BlockSlot {
    @SerialClass.SerialField(toClient=true)
    public final ItemEntry[] entries = new ItemEntry[]{new ItemEntry(), new ItemEntry()};

    public GrillBlockEntity(BlockEntityType<? extends GrillBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    public ItemStack getStack(int i) {
        if (i < 0 || i >= this.size()) {
            return ItemStack.f_41583_;
        }
        return this.entries[i].stack;
    }

    public boolean addItem(int i, ItemStack stack) {
        if (i < 0 || i >= this.size()) {
            return false;
        }
        return this.entries[i].addItem(this, stack);
    }

    @Override
    public AABB getBox() {
        return GrillBlock.OUTER.m_83215_().m_82338_(this.m_58899_()).m_82386_(0.0, 0.0625, 0.0).m_82406_((double)0.01f);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        boolean heat = this.isHeated();
        for (ItemEntry e : this.entries) {
            e.tick(this, heat);
        }
        if (this.f_58857_.m_5776_() && heat) {
            this.addParticles();
        }
    }

    public boolean canFlip(int i) {
        if (i < 0 || i >= this.size()) {
            return false;
        }
        return this.entries[i].canFlip();
    }

    public boolean flip(int i) {
        if (i < 0 || i >= this.size()) {
            return false;
        }
        return this.entries[i].flip(this);
    }

    public boolean isFlipped(int i) {
        if (i < 0 || i >= this.size()) {
            return false;
        }
        return this.entries[i].flipped;
    }

    public boolean isHeated() {
        return (Boolean)this.m_58900_().m_61143_((Property)GrillPlace.CAMPFIRE) != false || this.f_58857_ != null && this.isHeated(this.f_58857_, this.m_58899_());
    }

    public boolean isBarbecuing() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (!this.isHeated()) {
            return false;
        }
        for (ItemEntry e : this.entries) {
            if (e.stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    private void addParticles() {
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        RandomSource r = level.f_46441_;
        if (r.m_188501_() < 0.2f && this.isBarbecuing()) {
            double x = (double)pos.m_123341_() + 0.5 + (r.m_188500_() * 0.4 - 0.2);
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5 + (r.m_188500_() * 0.4 - 0.2);
            double motionY = r.m_188499_() ? 0.015 : 0.005;
            level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
        }
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i].stack.m_41619_()) continue;
            double x0 = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 1.0;
            double z0 = (double)pos.m_123343_() + 0.5;
            float v1 = this.getOffset(i);
            Direction dir = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            int index = dir.m_122416_();
            Vec2 offset = index % 2 == 0 ? new Vec2(v1, 0.0f) : new Vec2(0.0f, v1);
            double x = x0 - (double)((float)dir.m_122429_() * offset.f_82470_) + (double)((float)dir.m_122427_().m_122429_() * offset.f_82470_);
            double z = z0 - (double)((float)dir.m_122431_() * offset.f_82471_) + (double)((float)dir.m_122427_().m_122431_() * offset.f_82471_);
            for (int j = 0; j < (this.entries[i].smoking() ? 8 : 1); ++j) {
                if (!(r.m_188501_() < 0.2f)) continue;
                double dx0 = (r.m_188500_() + r.m_188500_() - 1.0) * (double)0.1f;
                double dz0 = (r.m_188500_() + r.m_188500_() - 1.0) * (double)0.1f;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + dx0, y, z + dz0, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public List<Container> getContainers() {
        ItemStack[] ans = new ItemStack[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ans[i] = this.entries[i].stack;
        }
        return List.of(new SimpleContainer(ans));
    }

    public void inventoryChanged() {
        this.m_6596_();
        this.sync();
    }

    @SerialClass
    public static class ItemEntry {
        @SerialClass.SerialField(toClient=true)
        public int time;
        @SerialClass.SerialField(toClient=true)
        public int duration;
        @SerialClass.SerialField(toClient=true)
        public boolean flipped;
        @SerialClass.SerialField(toClient=true)
        public boolean burnt;
        @SerialClass.SerialField(toClient=true)
        public ItemStack stack = ItemStack.f_41583_;

        public void tick(GrillBlockEntity be, boolean heated) {
            if (be.f_58857_ == null) {
                return;
            }
            if (this.stack.m_41619_()) {
                return;
            }
            if (!heated) {
                if (this.time > 0) {
                    this.time -= 2;
                    if (this.time <= 0) {
                        this.time = 0;
                    }
                }
                return;
            }
            if (this.stack.m_41619_()) {
                return;
            }
            ++this.time;
            if (this.time < this.duration) {
                return;
            }
            if (this.time >= this.duration * 2) {
                this.burnt = true;
                this.stack = BBQDItems.BURNT_FOOD.asStack();
                be.inventoryChanged();
            }
            if (!this.flipped) {
                return;
            }
            if (this.time == this.duration && !be.f_58857_.m_5776_()) {
                SimpleContainer cont = new SimpleContainer(new ItemStack[]{this.stack});
                Optional opt = be.f_58857_.m_7465_().m_44015_((RecipeType)BBQDRecipes.RT_BBQ.get(), (Container)cont, be.f_58857_);
                if (opt.isPresent()) {
                    CompoundTag tag = this.stack.m_41783_();
                    this.stack = ((GrillingRecipe)((Object)opt.get())).m_5874_((Container)cont, be.f_58857_.m_9598_());
                    this.stack.m_41751_(tag);
                    be.inventoryChanged();
                }
            }
        }

        public boolean canFlip() {
            return !this.stack.m_41619_() && !this.flipped && !this.burnt && this.time >= this.duration / 2;
        }

        public boolean smoking() {
            return this.burnt || this.canFlip() || this.flipped && this.time >= this.duration;
        }

        public boolean flip(GrillBlockEntity be) {
            if (be.f_58857_ == null) {
                return false;
            }
            if (!this.canFlip()) {
                return false;
            }
            this.flipped = true;
            this.time = this.duration / 2;
            if (!be.f_58857_.m_5776_()) {
                be.inventoryChanged();
            }
            be.f_58857_.m_5594_(null, be.m_58899_(), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            return true;
        }

        public boolean addItem(GrillBlockEntity be, ItemStack stack) {
            if (be.f_58857_ == null) {
                return false;
            }
            Optional opt = be.f_58857_.m_7465_().m_44015_((RecipeType)BBQDRecipes.RT_BBQ.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), be.f_58857_);
            if (opt.isEmpty()) {
                return false;
            }
            if (!((GrillBlockEntity)be).f_58857_.f_46443_) {
                this.duration = ((GrillingRecipe)((Object)opt.get())).getBarbecuingTime();
                this.time = 0;
                this.burnt = false;
                this.flipped = false;
                this.stack = stack.m_255036_(1);
                stack.m_41774_(1);
                be.inventoryChanged();
            }
            be.f_58857_.m_5594_(null, be.m_58899_(), SoundEvents.f_12028_, SoundSource.BLOCKS, 0.7f, 1.0f);
            return true;
        }

        public Component getTooltip() {
            if (this.burnt) {
                return BBQLangData.JADE_BURNT.get(new Object[0]);
            }
            if (!this.flipped) {
                if (this.time < this.duration / 2) {
                    return BBQLangData.JADE_COOK.get((this.duration / 2 - this.time + 19) / 20);
                }
                return BBQLangData.JADE_FLIP.get(new Object[0]);
            }
            if (this.time < this.duration) {
                return BBQLangData.JADE_COOK.get((this.duration - this.time + 19) / 20);
            }
            return BBQLangData.JADE_COOKED.get(new Object[0]);
        }
    }
}

