/*
 * Decompiled with CFR 0.152.
 */
package com.mao.barbequesdelight.content.block;

import com.mao.barbequesdelight.content.block.GrillBlockEntity;
import com.mao.barbequesdelight.content.item.SeasoningItem;
import com.mao.barbequesdelight.init.registrate.BBQDBlocks;
import dev.xkmc.l2modularblock.impl.BlockEntityBlockMethodImpl;
import dev.xkmc.l2modularblock.mult.AnimateTickBlockMethod;
import dev.xkmc.l2modularblock.mult.OnClickBlockMethod;
import dev.xkmc.l2modularblock.one.ShapeBlockMethod;
import dev.xkmc.l2modularblock.type.BlockMethod;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class GrillBlock
implements ShapeBlockMethod,
AnimateTickBlockMethod,
OnClickBlockMethod {
    public static final BlockMethod TE = new BlockEntityBlockMethodImpl(BBQDBlocks.TE_GRILL, GrillBlockEntity.class);
    public static final VoxelShape OUTER = Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        GrillBlockEntity grill;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GrillBlockEntity && (grill = (GrillBlockEntity)blockEntity).isBarbecuing()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(8) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get(), SoundSource.BLOCKS, 0.4f, random.m_188501_() * 0.2f + 0.9f, false);
            }
        }
    }

    public InteractionResult onClick(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SeasoningItem seasoning;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof GrillBlockEntity)) {
            return InteractionResult.PASS;
        }
        GrillBlockEntity grill = (GrillBlockEntity)blockEntity;
        int i = grill.getSlotForHitting(hit, level);
        ItemStack stack = player.m_21120_(hand);
        if (i < 0 || i >= grill.size()) {
            return InteractionResult.PASS;
        }
        ItemStack item = grill.getStack(i);
        if (item.m_41619_()) {
            if (stack.m_41619_()) {
                return InteractionResult.PASS;
            }
            return grill.addItem(i, stack) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            return grill.flip(i) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        Item item2 = stack.m_41720_();
        if (item2 instanceof SeasoningItem && (seasoning = (SeasoningItem)item2).canSprinkle(item)) {
            seasoning.sprinkle(stack, hit.m_82450_(), item, player, hand);
            return InteractionResult.SUCCESS;
        }
        if (!level.m_5776_()) {
            ItemStack ret = item.m_41620_(1);
            if (player.m_21120_(hand).m_41619_()) {
                player.m_21008_(hand, ret);
            } else {
                player.m_150109_().m_150079_(ret);
            }
            grill.inventoryChanged();
        }
        return InteractionResult.SUCCESS;
    }
}

