/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.networking;

import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.dawnoftime.armoroftheages.networking.ForgeConfigSyncNetworkHandler;

class GlobalPreferenceSyncPacketHandler {
    private final ForgeConfigSyncNetworkHandler forgeConfigSyncNetworkHandler;
    private HashMap<UUID, PreferredModel> map;

    public GlobalPreferenceSyncPacketHandler(ForgeConfigSyncNetworkHandler forgeConfigSyncNetworkHandler, HashMap<UUID, PreferredModel> map) {
        this.forgeConfigSyncNetworkHandler = forgeConfigSyncNetworkHandler;
        this.map = map;
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeInt(this.map.size());
        this.map.forEach((uuid, model) -> {
            buffer.m_130077_(uuid);
            buffer.m_130068_((Enum)model);
        });
    }

    public static GlobalPreferenceSyncPacketHandler decoder(ForgeConfigSyncNetworkHandler handler, FriendlyByteBuf buffer) {
        HashMap<UUID, PreferredModel> map = new HashMap<UUID, PreferredModel>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            map.put(buffer.m_130259_(), (PreferredModel)buffer.m_130066_(PreferredModel.class));
        }
        return new GlobalPreferenceSyncPacketHandler(handler, map);
    }

    public void messageConsumer(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.forgeConfigSyncNetworkHandler.mapHandler.accept(this.map));
        ctx.get().setPacketHandled(true);
    }
}

