/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages.networking;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.config.PreferredModel;
import org.dawnoftime.armoroftheages.networking.ConfigSyncNetworkHandler;
import org.dawnoftime.armoroftheages.networking.DisabledPreferencesPacketHandler;
import org.dawnoftime.armoroftheages.networking.GlobalPreferenceSyncPacketHandler;
import org.dawnoftime.armoroftheages.networking.PreferenceSyncPacketHandler;

public class ForgeConfigSyncNetworkHandler
implements ConfigSyncNetworkHandler {
    public final HashMap<UUID, PreferredModel> CURRENT_SERVER_STATE = new HashMap();
    public Consumer<HashMap<UUID, PreferredModel>> mapHandler = null;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.m_214293_((String)"armoroftheages", (String)"config_sync"), () -> "1", "1"::equals, "1"::equals);
    private int id = 0;

    @Override
    public void syncConfig() {
        if (Minecraft.m_91087_().m_91403_() != null) {
            if (!AOTAConfig.get().usePreferredModel) {
                INSTANCE.sendToServer((Object)new DisabledPreferencesPacketHandler(this));
            } else {
                INSTANCE.sendToServer((Object)new PreferenceSyncPacketHandler(this, AOTAConfig.get().preferredModel));
            }
        }
    }

    @Override
    public void registerHandler(Consumer<HashMap<UUID, PreferredModel>> handler) {
        this.mapHandler = handler;
    }

    @Override
    public void setup() {
        INSTANCE.messageBuilder(DisabledPreferencesPacketHandler.class, this.id++).encoder(DisabledPreferencesPacketHandler::encoder).decoder(friendlyByteBuf -> DisabledPreferencesPacketHandler.decoder(this, friendlyByteBuf)).consumerMainThread(DisabledPreferencesPacketHandler::messageConsumer).add();
        INSTANCE.messageBuilder(PreferenceSyncPacketHandler.class, this.id++).encoder(PreferenceSyncPacketHandler::encoder).decoder(friendlyByteBuf -> PreferenceSyncPacketHandler.decoder(this, friendlyByteBuf)).consumerMainThread(PreferenceSyncPacketHandler::messageConsumer).add();
        INSTANCE.messageBuilder(GlobalPreferenceSyncPacketHandler.class, this.id++).encoder(GlobalPreferenceSyncPacketHandler::encoder).decoder(friendlyByteBuf -> GlobalPreferenceSyncPacketHandler.decoder(this, friendlyByteBuf)).consumerMainThread(GlobalPreferenceSyncPacketHandler::messageConsumer).add();
    }

    void globalSync(MinecraftServer server) {
        FriendlyByteBuf responseBuf = new FriendlyByteBuf(Unpooled.buffer());
        responseBuf.writeInt(this.CURRENT_SERVER_STATE.size());
        this.CURRENT_SERVER_STATE.forEach((uuid, model) -> {
            responseBuf.m_130077_(uuid);
            responseBuf.m_130068_((Enum)model);
        });
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GlobalPreferenceSyncPacketHandler(this, this.CURRENT_SERVER_STATE));
        }
    }
}

