/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.armoroftheages;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dawnoftime.armoroftheages.CommonClass;
import org.dawnoftime.armoroftheages.Constants;
import org.dawnoftime.armoroftheages.client.ArmorOfTheAgesClientForge;
import org.dawnoftime.armoroftheages.config.AOTAConfig;
import org.dawnoftime.armoroftheages.item.ForgeHumanoidArmorItem;
import org.dawnoftime.armoroftheages.loot.LootModifierProvider;
import org.dawnoftime.armoroftheages.loot.LootModifiers;
import org.dawnoftime.armoroftheages.networking.ForgeConfigSyncNetworkHandler;
import org.dawnoftime.armoroftheages.registry.ItemRegistry;

@Mod(value="armoroftheages")
public class ArmorOfTheAgesForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"armoroftheages");

    public ArmorOfTheAgesForge() {
        Constants.CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("armoroftheages.json");
        ArmorOfTheAgesForge.migrateForgeConfigIfNeeded();
        CommonClass.CONFIG_SYNC_HANDLER = new ForgeConfigSyncNetworkHandler();
        CommonClass.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemRegistryImpl.REGISTRY = new ItemRegistryImpl();
        ItemRegistryImpl.DEFERRED_REGISTER.register(modEventBus);
        CREATIVE_MODE_TAB.register(modEventBus);
        CREATIVE_MODE_TAB.register("armoroftheages", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.armoroftheages")).m_257737_(() -> ItemRegistry.REGISTRY.TAB_ICON.get().m_7968_()).m_257501_((params, output) -> output.m_246601_(ItemRegistryImpl.DEFERRED_REGISTER.getEntries().stream().filter(holder -> holder != ItemRegistry.REGISTRY.TAB_ICON).map(holder -> ((Item)holder.get()).m_7968_()).toList())).m_257652_());
        LootModifiers.register(modEventBus);
        modEventBus.addListener(this::gatherData);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> AOTAConfig.createScreen().generateScreen(parent)));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(ArmorOfTheAgesClientForge::registerLayerDefinitions);
            MinecraftForge.EVENT_BUS.addListener(ArmorOfTheAgesClientForge::playerLoggedInEvent);
        }
    }

    public void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), LootModifierProvider::new);
    }

    private static void migrateForgeConfigIfNeeded() {
        block18: {
            Path configDir = FMLPaths.CONFIGDIR.get();
            Path oldDir = configDir.resolve("config");
            Path oldFile = oldDir.resolve("armoroftheages.json");
            Path newFile = configDir.resolve("armoroftheages.json");
            try {
                if (!Files.exists(oldFile, new LinkOption[0])) break block18;
                if (!Files.exists(newFile, new LinkOption[0])) {
                    try {
                        Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
                        Files.copy(oldFile, newFile, StandardCopyOption.REPLACE_EXISTING);
                        LOGGER.info("[{}] Configuration migrated from '{}' to '{}'.", (Object)"armoroftheages", (Object)oldFile, (Object)newFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("[{}] Failed to copy old configuration '{}' to '{}': {}", (Object)"armoroftheages", (Object)oldFile, (Object)newFile, (Object)e.getMessage());
                    }
                } else {
                    LOGGER.info("[{}] New configuration file already present: '{}'. The old one will be cleaned up if possible.", (Object)"armoroftheages", (Object)newFile);
                }
                try {
                    Files.deleteIfExists(oldFile);
                }
                catch (IOException e) {
                    LOGGER.warn("[{}] Failed to delete old configuration file '{}': {}", (Object)"armoroftheages", (Object)oldFile, (Object)e.getMessage());
                }
                try {
                    if (!Files.isDirectory(oldDir, new LinkOption[0])) break block18;
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(oldDir);){
                        Iterator<Path> it = ds.iterator();
                        if (!it.hasNext()) {
                            Files.delete(oldDir);
                            LOGGER.info("[{}] Old folder '{}' deleted (was empty).", (Object)"armoroftheages", (Object)oldDir);
                        } else {
                            LOGGER.info("[{}] Old folder '{}' kept (contents detected).", (Object)"armoroftheages", (Object)oldDir);
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("[{}] Failed to clean up old folder '{}': {}", (Object)"armoroftheages", (Object)oldDir, (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.warn("[{}] Problem during configuration migration: {}", (Object)"armoroftheages", (Object)e.getMessage());
            }
        }
    }

    public static class ItemRegistryImpl
    extends ItemRegistry {
        public static final DeferredRegister<Item> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"armoroftheages");
        public static final Map<String, List<ResourceLocation>> ARMORS_LOCATION_FROM_NAME = new Object2ObjectOpenHashMap();

        @Override
        public void register(String armorSetName, ArmorMaterial material, ArmorItem.Type slot) {
            ARMORS_LOCATION_FROM_NAME.computeIfAbsent(armorSetName, s -> new ObjectArrayList()).add(new ResourceLocation("armoroftheages", armorSetName + "_" + slot.m_266308_().m_20751_()));
            DEFERRED_REGISTER.register(armorSetName + "_" + slot.m_266308_().m_20751_(), () -> new ForgeHumanoidArmorItem(armorSetName, material, slot));
        }

        @Override
        public Supplier<Item> register(String name, Supplier<Item> itemSupplier) {
            ARMORS_LOCATION_FROM_NAME.computeIfAbsent(name, s -> new ObjectArrayList()).add(new ResourceLocation("armoroftheages", name));
            return DEFERRED_REGISTER.register(name, itemSupplier);
        }
    }
}

