/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.items.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.sonmok14.fromtheshadows.server.utils.registry.ParticleRegistry;

public class DevilSplitterHandler {
    private static final int MAX_HITS = 6;
    private static final long TIME_LIMIT_MS = 20000L;
    private static final Map<UUID, Map<UUID, HitData>> hitTracker = new HashMap<UUID, Map<UUID, HitData>>();

    public static void onHitEntity(LivingEntity attacker, LivingEntity target) {
        UUID attackerId = attacker.m_20148_();
        UUID targetId = target.m_20148_();
        long now = System.currentTimeMillis();
        hitTracker.putIfAbsent(attackerId, new HashMap());
        Map<UUID, HitData> targetMap = hitTracker.get(attackerId);
        HitData hitData = targetMap.getOrDefault(targetId, new HitData());
        if (now - hitData.startTime > 20000L) {
            hitData = new HitData();
        }
        ++hitData.hits;
        long l = hitData.startTime = hitData.startTime == 0L ? now : hitData.startTime;
        if (hitData.hits == 6) {
            float damage = DevilSplitterHandler.getFullAttackDamage((Player)attacker, target);
            target.m_6469_(target.m_269291_().m_269075_((Player)attacker), damage);
            Level level = attacker.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.RED_LIGHTNING.get()), target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 12, 0.0, 0.0, 0.0, 1.0);
            }
            attacker.m_9236_().m_5594_(null, attacker.m_20183_(), SoundEvents.f_11895_, SoundSource.PLAYERS, 1.0f, 1.0f);
            targetMap.remove(targetId);
        } else {
            targetMap.put(targetId, hitData);
        }
        hitTracker.put(attackerId, targetMap);
    }

    private static float getFullAttackDamage(Player player, LivingEntity target) {
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
        ItemStack weapon = player.m_21205_();
        float enchantBonus = EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)target.m_6336_());
        boolean isCrit = player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_();
        float attackStrength = player.m_36403_(0.5f);
        float totalDamage = baseDamage * (0.2f + attackStrength * attackStrength * 0.8f);
        if (enchantBonus > 0.0f) {
            totalDamage += enchantBonus * attackStrength;
        }
        if (isCrit) {
            totalDamage *= 1.5f;
        }
        if (player.m_21023_(MobEffects.f_19600_)) {
            int amplifier = player.m_21124_(MobEffects.f_19600_).m_19564_();
            totalDamage += (float)(3 * (amplifier + 1));
        }
        return totalDamage * 2.0f;
    }

    private static class HitData {
        int hits = 0;
        long startTime = 0L;

        private HitData() {
        }
    }
}

