/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server.entity.mob;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.entity.projectiles.ThrowingDaggerEntity;
import net.sonmok14.fromtheshadows.server.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EnchantmentRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ClericEntity
extends AbstractIllager
implements GeoEntity {
    static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34082_ -> p_34082_ == Difficulty.NORMAL || p_34082_ == Difficulty.HARD;
    public int throwingdaggercooldown;
    public int attackID;
    public int attacktick;
    public float mumbleProgress;
    public static final byte MELEE_ATTACK = 1;
    public static final byte THROWING_ATTACK = 2;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ClericEntity(EntityType<ClericEntity> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
        ClericEntity.setConfigattribute((LivingEntity)this, FTSConfig.cleric_health_multiplier, FTSConfig.cleric_melee_damage_multiplier);
    }

    @Nullable
    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public static void setConfigattribute(LivingEntity entity, double hpconfig, double dmgconfig) {
        AttributeInstance attackDamageAttr;
        AttributeInstance maxHealthAttr = entity.m_21051_(Attributes.f_22276_);
        if (maxHealthAttr != null) {
            double difference = maxHealthAttr.m_22115_() * hpconfig - maxHealthAttr.m_22115_();
            maxHealthAttr.m_22118_(new AttributeModifier(UUID.fromString("6d57ab59-6f61-4bb9-9fee-6a0c75aea861"), "Health config multiplier", difference, AttributeModifier.Operation.ADDITION));
            entity.m_21153_(entity.m_21233_());
        }
        if ((attackDamageAttr = entity.m_21051_(Attributes.f_22281_)) != null) {
            double difference = attackDamageAttr.m_22115_() * dmgconfig - attackDamageAttr.m_22115_();
            attackDamageAttr.m_22118_(new AttributeModifier(UUID.fromString("6d57ab59-6f61-4bb9-9fee-6a0c75aea861"), "Attack config multiplier", difference, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void m_8024_() {
        if (!this.m_21525_() && GoalUtils.m_26894_((Mob)this)) {
            boolean flag = ((ServerLevel)this.m_9236_()).m_8843_(this.m_20183_());
            ((GroundPathNavigation)this.m_21573_()).m_26477_(flag);
        }
        super.m_8024_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 7, event -> {
            event.getController().setAnimationSpeed(0.5);
            if (this.attackID == 2 && this.attacktick <= 13) {
                event.getController().setAnimationSpeed(1.0);
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.cultist.throw_dagger_ready"));
            }
            if (this.attackID == 2 && this.attacktick > 13) {
                event.getController().setAnimationSpeed(1.0);
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.cultist.throw_dagger"));
            }
            if (this.attackID == 1) {
                event.getController().setAnimationSpeed(1.0);
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.cultist.melee_attack"));
            }
            if (this.attackID == 0 && this.f_267362_.m_267731_() > 0.35f && this.m_5912_()) {
                event.getController().setAnimationSpeed(1.0);
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cultist.run"));
            }
            if (this.f_267362_.m_267731_() > 0.01f) {
                event.getController().setAnimationSpeed(1.0);
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cultist.walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cultist.idle"));
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "mumble", 15, event -> {
            event.getController().setAnimationSpeed(0.5);
            if (this.mumbleProgress <= 35.0f) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.cultist.mumble"));
            }
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("mumblekey") && this.m_9236_().f_46443_) {
                this.m_20193_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.CULTIST_IDLE.get(), SoundSource.HOSTILE, 1.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f, true);
            }
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_7301_(MobEffectInstance p_31495_) {
        return p_31495_.m_19544_() == EffectRegistry.PLAGUE.get() ? false : super.m_7301_(p_31495_);
    }

    public MobType m_6336_() {
        return MobType.f_21643_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_21364_ = 10;
        if (!this.m_9236_().f_46443_) {
            this.m_21195_((MobEffect)EffectRegistry.PLAGUE.get());
        }
        if (this.throwingdaggercooldown > 0) {
            --this.throwingdaggercooldown;
        }
        if (this.throwingdaggercooldown == 0 && this.attackID == 2) {
            this.throwingdaggercooldown = 200;
        }
        if (this.attackID != 0) {
            this.f_20883_ = this.f_20885_;
            this.m_146922_(this.f_20883_);
            ++this.attacktick;
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 90.0f);
            }
        }
        if (this.mumbleProgress > 0.0f) {
            this.mumbleProgress -= 1.0f;
        }
        if (this.mumbleProgress == 0.0f) {
            this.mumbleProgress = 200.0f;
        }
    }

    public void setAttackID(int id) {
        this.attackID = id;
        this.attacktick = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)(-id));
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.attackID != 0) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            p_32394_ = Vec3.f_82478_;
            super.m_7023_(p_32394_);
            return;
        }
        super.m_7023_(p_32394_);
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackID = Math.abs(id);
            this.attacktick = 0;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return ClericEntity.rollSpawn(FTSConfig.clericSpawnRolls, this.m_217043_(), spawnReasonIn);
    }

    public static boolean rollSpawn(int rolls, RandomSource random, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        return rolls <= 0 || random.m_188503_(rolls) == 0 && random.m_188503_(8) == 0;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @javax.annotation.Nullable SpawnGroupData p_34091_, @javax.annotation.Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        this.m_213946_(randomsource, p_34089_);
        return spawngroupdata;
    }

    protected void m_213945_(RandomSource p_219149_, DifficultyInstance p_219150_) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemRegistry.PLAGUE_DOCTOR_MASK.get()));
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        }
    }

    public boolean m_7327_(Entity p_85031_1_) {
        if (!this.m_9236_().f_46443_ && this.attackID == 0) {
            this.attackID = 1;
        }
        return true;
    }

    public boolean m_7490_() {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundRegistry.CULTIST_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.CULTIST_DEATH.get();
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    public boolean m_7307_(Entity p_34110_) {
        if (super.m_7307_(p_34110_)) {
            return true;
        }
        if (p_34110_ instanceof LivingEntity && ((LivingEntity)p_34110_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_34110_.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_34079_, boolean p_34080_) {
        boolean flag;
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42386_);
        Raid raid = this.m_37885_();
        int i = 1;
        if (p_34079_ > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            HashMap map = Maps.newHashMap();
            map.put((Enchantment)EnchantmentRegistry.FREEZING.get(), i);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
    }

    public void throwDagger() {
        if (this.m_5448_() != null) {
            int count = 3;
            double offsetangle = Math.toRadians(5.0);
            double d1 = this.m_5448_().m_20185_() - this.m_20185_();
            double d2 = this.m_5448_().m_20186_() - this.m_20186_();
            double d3 = this.m_5448_().m_20189_() - this.m_20189_();
            for (int i = 0; i <= count - 1; ++i) {
                double angle = (double)(i - (count - 1) / 4) * offsetangle;
                ThrowingDaggerEntity throwingDaggerEntity = new ThrowingDaggerEntity(this.m_9236_(), (LivingEntity)this, null);
                double f0 = this.m_5448_().m_20185_() - this.m_20185_();
                double f1 = this.m_5448_().m_20227_(0.3333333333333333) - throwingDaggerEntity.m_20186_();
                double f2 = this.m_5448_().m_20189_() - this.m_20189_();
                double f3 = Math.sqrt(f0 * f0 + f2 * f2);
                double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                throwingDaggerEntity.m_6686_(x, f1 + f3 * (double)0.1f, z, 2.0f, 16 - this.m_9236_().m_46791_().m_19028_() * 4);
                this.m_9236_().m_7967_((Entity)throwingDaggerEntity);
            }
        }
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        if (this.attackID == 2) {
            return 0;
        }
        return super.m_5639_(p_21237_, p_21238_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClericBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(0, (Goal)new ThrowingAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new AxeMeleeAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5, 25, true));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public int m_5792_() {
        return 1;
    }

    static class ClericBreakDoorGoal
    extends BreakDoorGoal {
        public ClericBreakDoorGoal(Mob p_34112_) {
            super(p_34112_, 6, DOOR_BREAKING_PREDICATE);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            ClericEntity clericEntity = (ClericEntity)this.f_25189_;
            return clericEntity.m_37886_() && super.m_8045_();
        }

        public boolean m_8036_() {
            ClericEntity clericEntity = (ClericEntity)this.f_25189_;
            return clericEntity.m_37886_() && clericEntity.f_19796_.m_188503_(ClericBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }

    class ThrowingAttackGoal
    extends Goal {
        private final ClericEntity clericEntity;
        private LivingEntity attackTarget;

        public ThrowingAttackGoal(ClericEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.clericEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.clericEntity.m_5448_();
            return this.attackTarget != null && ClericEntity.this.attackID == 0 && ClericEntity.this.m_20270_((Entity)this.attackTarget) <= 1024.0f && ClericEntity.this.f_19796_.m_188503_(8) == 0 && ClericEntity.this.throwingdaggercooldown == 0;
        }

        public void m_8056_() {
            this.clericEntity.setAttackID(2);
        }

        public void m_8041_() {
            this.clericEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.clericEntity.attacktick < 30;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (ClericEntity.this.attacktick == 1) {
                this.clericEntity.m_5496_((SoundEvent)SoundRegistry.CULTIST_PREATTACK.get(), 2.0f, 0.3f + this.clericEntity.m_217043_().m_188501_() * 0.1f);
            }
            if (ClericEntity.this.attacktick == 16) {
                this.clericEntity.m_5496_((SoundEvent)SoundRegistry.CULTIST_ATTACK.get(), 2.0f, 0.3f + this.clericEntity.m_217043_().m_188501_() * 0.1f);
                float f1 = (float)Math.cos(Math.toRadians(ClericEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(ClericEntity.this.m_146908_() + 90.0f));
                ClericEntity.this.m_5997_(f1 * -1.0f, 0.5, f2 * -1.0f);
            }
            if (ClericEntity.this.attacktick == 18) {
                ClericEntity.this.throwDagger();
            }
            ClericEntity.this.m_21573_().m_26569_();
        }
    }

    class AxeMeleeAttackGoal
    extends Goal {
        private final ClericEntity clericEntity;
        private LivingEntity attackTarget;

        public AxeMeleeAttackGoal(ClericEntity p_i45837_1_) {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.clericEntity = p_i45837_1_;
        }

        public boolean m_8036_() {
            this.attackTarget = this.clericEntity.m_5448_();
            return this.attackTarget != null && this.clericEntity.attackID == 1;
        }

        public void m_8056_() {
            this.clericEntity.setAttackID(1);
        }

        public void m_8041_() {
            this.clericEntity.setAttackID(0);
            this.attackTarget = null;
        }

        public boolean m_8045_() {
            return this.clericEntity.attacktick < 28;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (ClericEntity.this.attacktick == 1) {
                this.clericEntity.m_5496_((SoundEvent)SoundRegistry.CULTIST_PREATTACK.get(), 2.0f, 0.3f + this.clericEntity.m_217043_().m_188501_() * 0.1f);
            }
            if (ClericEntity.this.attacktick == 16) {
                float f1 = (float)Math.cos(Math.toRadians(ClericEntity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(ClericEntity.this.m_146908_() + 90.0f));
                this.clericEntity.m_5496_((SoundEvent)SoundRegistry.CULTIST_ATTACK.get(), 2.0f, 0.3f + this.clericEntity.m_217043_().m_188501_() * 0.1f);
                ClericEntity.this.m_5997_(f1 * 1.0f, 0.0, f2 * 1.0f);
            }
            if (ClericEntity.this.attacktick == 20 && ClericEntity.this.m_20270_((Entity)this.attackTarget) <= 3.5f) {
                this.attackTarget.m_6469_(ClericEntity.this.m_269291_().m_269333_((LivingEntity)this.clericEntity), (float)ClericEntity.this.m_21133_(Attributes.f_22281_));
            }
            ClericEntity.this.m_21573_().m_26569_();
        }
    }
}

