/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.server;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.sonmok14.fromtheshadows.client.ClientProxy;
import net.sonmok14.fromtheshadows.server.CommonProxy;
import net.sonmok14.fromtheshadows.server.config.BiomeConfig;
import net.sonmok14.fromtheshadows.server.config.ConfigHolder;
import net.sonmok14.fromtheshadows.server.config.FTSConfig;
import net.sonmok14.fromtheshadows.server.utils.event.ServerEvents;
import net.sonmok14.fromtheshadows.server.utils.registry.BlockRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EffectRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EnchantmentRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.EntityRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.FTSCreativeTabRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ItemRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.ParticleRegistry;
import net.sonmok14.fromtheshadows.server.utils.registry.SoundRegistry;
import net.sonmok14.fromtheshadows.server.world.biome.FTSMobSpawnBiomeModifier;
import net.sonmok14.fromtheshadows.server.world.biome.FTSMobSpawnStructureModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="fromtheshadows")
public class Fromtheshadows {
    public static Fromtheshadows instance;
    public static final String MODID = "fromtheshadows";
    public static final Logger LOGGER;
    public static CommonProxy PROXY;

    public Fromtheshadows() {
        instance = this;
        GeckoLib.initialize();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        PROXY.commonInit();
        modEventBus.addListener(this::onModConfigEvent);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHolder.COMMON_SPEC, "from_the_shadows.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        EntityRegistry.ENTITY_TYPES.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        ParticleRegistry.PARTICLES.register(modEventBus);
        SoundRegistry.MOD_SOUNDS.register(modEventBus);
        EnchantmentRegistry.ENCHANTMENT.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        EffectRegistry.EFFECT.register(modEventBus);
        EffectRegistry.POTION.register(modEventBus);
        FTSCreativeTabRegistry.TABS.register(modEventBus);
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("from_the_shadows_mob_spawns", FTSMobSpawnBiomeModifier::makeCodec);
        DeferredRegister structureModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, (String)MODID);
        structureModifiers.register(modEventBus);
        structureModifiers.register("from_the_shadows_structure_spawns", FTSMobSpawnStructureModifier::makeCodec);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Raid.RaiderType.create((String)MODID, (EntityType)((EntityType)EntityRegistry.CLERIC.get()), (int[])new int[]{0, 1, 2, 2, 0, 2, 0, 4}));
        EffectRegistry.init();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> PROXY.clientInit());
    }

    @SubscribeEvent
    public void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
            FTSConfig.bake(config);
        }
        BiomeConfig.init();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    static {
        LOGGER = LogManager.getLogger();
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }
}

