/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sonmok14.fromtheshadows.client.renderer.FTSRenderType;
import net.sonmok14.fromtheshadows.server.entity.projectiles.PlayerProjectileEntity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class PlayerProjectileRenderer
extends EntityRenderer<PlayerProjectileEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("fromtheshadows", "textures/entity/player_breath.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 0.75f;
    private static final float BEAM_RADIUS = 0.75f;
    private boolean clearerView = false;

    public PlayerProjectileRenderer(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(PlayerProjectileEntity entity) {
        return TEXTURE;
    }

    public void render(PlayerProjectileEntity playerBreath, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.clearerView = playerBreath.caster instanceof Player && Minecraft.m_91087_().f_91074_ == playerBreath.caster && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON;
        double collidePosX = playerBreath.prevCollidePosX + (playerBreath.collidePosX - playerBreath.prevCollidePosX) * (double)delta;
        double collidePosY = playerBreath.prevCollidePosY + (playerBreath.collidePosY - playerBreath.prevCollidePosY) * (double)delta;
        double collidePosZ = playerBreath.prevCollidePosZ + (playerBreath.collidePosZ - playerBreath.prevCollidePosZ) * (double)delta;
        double posX = playerBreath.f_19854_ + (playerBreath.m_20185_() - playerBreath.f_19854_) * (double)delta;
        double posY = playerBreath.f_19855_ + (playerBreath.m_20186_() - playerBreath.f_19855_) * (double)delta;
        double posZ = playerBreath.f_19856_ + (playerBreath.m_20189_() - playerBreath.f_19856_) * (double)delta;
        float yaw = playerBreath.prevYaw + (playerBreath.renderYaw - playerBreath.prevYaw) * delta;
        float pitch = playerBreath.prevPitch + (playerBreath.renderPitch - playerBreath.prevPitch) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(playerBreath.appear.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(FTSRenderType.getGlowingEffect(this.getTextureLocation(playerBreath)));
        this.renderStart(frame, matrixStackIn, ivertexbuilder, packedLightIn);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, matrixStackIn, ivertexbuilder, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(frame, playerBreath.blockSide, matrixStackIn, ivertexbuilder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f, -0.75f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f, 0.75f, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f, 0.75f, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f, -0.75f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderStart(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        if (this.clearerView) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternionf quat = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quat = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternionf sideQuat = side.m_253075_();
        sideQuat.mul((Quaternionfc)new Quaternionf().rotationX(1.5707964f));
        matrixStackIn.m_252781_(sideQuat);
        matrixStackIn.m_252880_(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        float offset = this.clearerView ? -1.0f : 0.0f;
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f, offset, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -0.75f, length, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f, length, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 0.75f, offset, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(new Quaternionf().rotationX(1.5707964f));
        matrixStackIn.m_252781_(new Quaternionf().rotationZ((yaw - 90.0f) * ((float)Math.PI / 180)));
        matrixStackIn.m_252781_(new Quaternionf().rotationX(-pitch * ((float)Math.PI / 180)));
        matrixStackIn.m_85836_();
        if (!this.clearerView) {
            matrixStackIn.m_252781_(new Quaternionf().rotationY(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 90.0f));
        }
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        if (!this.clearerView) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(new Quaternionf().rotationY((-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 90.0f) * ((float)Math.PI / 180)));
            this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85849_();
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

