/*
 * Decompiled with CFR 0.152.
 */
package net.sonmok14.fromtheshadows.client.models.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector4f;
import software.bernie.geckolib.cache.object.GeoBone;

public class AdvancedGeoBone
extends GeoBone {
    public Matrix4f rotationOverride;
    public boolean inheritRotation = true;
    public boolean inheritTranslation = true;
    protected boolean forceMatrixTransform = false;
    private boolean isDynamicJoint = false;

    public AdvancedGeoBone(@Nullable GeoBone parent, String name, Boolean mirror, @Nullable Double inflate, @Nullable Boolean dontRender, @Nullable Boolean reset) {
        super(parent, name, mirror, inflate, dontRender, reset);
        this.rotationOverride = null;
    }

    public AdvancedGeoBone(AdvancedGeoBone geoBone) {
        super(null, geoBone.getName() + "_chain", geoBone.getMirror(), geoBone.getInflate(), geoBone.shouldNeverRender(), geoBone.getReset());
        this.setPos(geoBone.getPos());
        this.setRot(geoBone.getRot());
        this.setPivotX(geoBone.getPivotX());
        this.setPivotY(geoBone.getPivotY());
        this.setPivotZ(geoBone.getPivotZ());
        this.setScale(geoBone.getScale());
        this.getCubes().addAll(geoBone.getCubes());
        this.saveInitialSnapshot();
        this.getChildBones().addAll(geoBone.getChildBones());
    }

    public AdvancedGeoBone getParent() {
        return (AdvancedGeoBone)super.getParent();
    }

    public void addPos(Vec3 vec) {
        this.addPos((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void addPos(float x, float y, float z) {
        this.addPosX(x);
        this.addPosY(y);
        this.addPosZ(z);
    }

    public void addPosX(float x) {
        this.setPosX(this.getPosX() + x);
    }

    public void addPosY(float y) {
        this.setPosY(this.getPosY() + y);
    }

    public void addPosZ(float z) {
        this.setPosZ(this.getPosZ() + z);
    }

    public void setPos(Vec3 vec) {
        this.setPos((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void setPos(float x, float y, float z) {
        this.setPosX(x);
        this.setPosY(y);
        this.setPosZ(z);
    }

    public Vec3 getPos() {
        return new Vec3((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    public void addRot(Vec3 vec) {
        this.addRot((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void addRot(float x, float y, float z) {
        this.addRotX(x);
        this.addRotY(y);
        this.addRotZ(z);
    }

    public void addRotX(float x) {
        this.setRotX(this.getRotX() + x);
    }

    public void addRotY(float y) {
        this.setRotY(this.getRotY() + y);
    }

    public void addRotZ(float z) {
        this.setRotZ(this.getRotZ() + z);
    }

    public void setRot(Vector3d vec) {
        this.setRot((float)vec.x(), (float)vec.y(), (float)vec.z());
    }

    public void setRot(Vec3 vec) {
        this.setRot((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void setRot(float x, float y, float z) {
        this.setRotX(x);
        this.setRotY(y);
        this.setRotZ(z);
    }

    public Vector3d getRot() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    public void multiplyScale(Vec3 vec) {
        this.multiplyScale((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void multiplyScale(float x, float y, float z) {
        this.setScaleX(this.getScaleX() * x);
        this.setScaleY(this.getScaleY() * y);
        this.setScaleZ(this.getScaleZ() * z);
    }

    public void setScale(Vec3 vec) {
        this.setScale((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    public void setScale(Vector3d vec) {
        this.setScale((float)vec.x(), (float)vec.y(), (float)vec.z());
    }

    public void setScale(float x, float y, float z) {
        this.setScaleX(x);
        this.setScaleY(y);
        this.setScaleZ(z);
    }

    public void setScale(float scale) {
        this.setScale(scale, scale, scale);
    }

    public Vector3d getScale() {
        return new Vector3d((double)this.getScaleX(), (double)this.getScaleY(), (double)this.getScaleZ());
    }

    public void addRotationOffsetFromBone(AdvancedGeoBone source) {
        this.setRotX(this.getRotX() + source.getRotX() - source.getInitialSnapshot().getRotX());
        this.setRotY(this.getRotY() + source.getRotY() - source.getInitialSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + source.getRotZ() - source.getInitialSnapshot().getRotZ());
    }

    public void setForceMatrixTransform(boolean forceMatrixTransform) {
        this.forceMatrixTransform = forceMatrixTransform;
    }

    public boolean isForceMatrixTransform() {
        return this.forceMatrixTransform;
    }

    public Matrix4f getModelRotationMat() {
        Matrix4f matrix = new Matrix4f((Matrix4fc)this.getModelSpaceMatrix());
        AdvancedGeoBone.removeMatrixTranslation(matrix);
        return matrix;
    }

    public static void removeMatrixTranslation(Matrix4f matrix) {
        matrix.m30(0.0f);
        matrix.m31(0.0f);
        matrix.m32(0.0f);
    }

    public void setModelXformOverride(Matrix4f mat) {
        this.rotationOverride = mat;
    }

    public void setWorldPos(Entity entity, Vec3 worldPos, float delta) {
        PoseStack matrixStack = new PoseStack();
        float dx = (float)(entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)delta);
        float dy = (float)(entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)delta);
        float dz = (float)(entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)delta);
        matrixStack.m_252880_(dx, dy, dz);
        float dYaw = Mth.m_14189_((float)delta, (float)entity.f_19859_, (float)entity.m_146908_());
        matrixStack.m_252781_(AdvancedGeoBone.quatFromRotationXYZ(0.0f, -dYaw + 180.0f, 0.0f, true));
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252880_(0.0f, -1.5f, 0.0f);
        PoseStack.Pose matrixEntry = matrixStack.m_85850_();
        Matrix4f matrix4f = matrixEntry.m_252922_();
        matrix4f.invert();
        Vector4f vec = new Vector4f((float)worldPos.m_7096_(), (float)worldPos.m_7098_(), (float)worldPos.m_7094_(), 1.0f);
        vec.mul((Matrix4fc)matrix4f);
        this.setPosX(vec.x() * 16.0f);
        this.setPosY(vec.y() * 16.0f);
        this.setPosZ(vec.z() * 16.0f);
    }

    public void setDynamicJoint(boolean dynamicJoint) {
        this.isDynamicJoint = dynamicJoint;
    }

    public boolean isDynamicJoint() {
        return this.isDynamicJoint;
    }

    public static Quaternionf quatFromRotationXYZ(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x *= (float)Math.PI / 180;
            y *= (float)Math.PI / 180;
            z *= (float)Math.PI / 180;
        }
        return new Quaternionf().rotationXYZ(x, y, z);
    }
}

