/*
 * Decompiled with CFR 0.152.
 */
package com.kamikaguya.ash_of_sin_custom_anti_seat_entity.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class CustomAntiSeatEntityConfig {
    public static final ForgeConfigSpec ANTI_SEAT_ENTITY_CONFIG;
    public static ForgeConfigSpec.BooleanValue ANTI_ON;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> ANTI_SEAT_ENTITY;
    public final Path configPath = FMLPaths.CONFIGDIR.get().resolve("ash_of_sin/custom_anti_seat_entity.toml");

    public CustomAntiSeatEntityConfig() {
        this.loadConfig();
    }

    public void loadConfig() {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create default custom anti seat entity config.", e);
            }
        }
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)this.configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        fileConfig.load();
        ANTI_SEAT_ENTITY_CONFIG.setConfig((CommentedConfig)fileConfig);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ANTI_ON = builder.comment("Anti On").comment("Enable Anti-Seat Entity").define("Anti On", true);
        ANTI_SEAT_ENTITY = builder.comment("Anti-Seat Entity").defineList("Anti-Seat Entity", () -> new ArrayList<String>(Arrays.asList("minecraft:wither", "minecraft:ender_dragon", "minecraft:warden", "minecraft:iron_golem", "cataclysm:ender_guardian", "cataclysm:ignis", "cataclysm:netherite_monstrosity", "cataclysm:the_harbinger", "cataclysm:the_leviathan", "cataclysm:ancient_ancient_remnant", "cataclysm:ancient_remnant", "cataclysm:maledictus", "aquamirae:captain_cornelia", "fromtheshadows:bulldrogioth", "fromtheshadows:nehemoth", "dodosmobs:bone_chimera", "block_factorys_bosses:infernal_dragon", "block_factorys_bosses:sandworm", "block_factorys_bosses:yeti", "block_factorys_bosses:underworld_knight", "fdbosses:malkuth", "fdbosses:chesed", "nightfall_invade:arterius", "alexsmobs:void_worm", "mowziesmobs:ferrous_wroughtnaut", "mowziesmobs:frostmaw", "mowziesmobs:umvuthi", "callfromthedepth_:agonysoul", "callfromthedepth_:injured_ancient_guard", "callfromthedepth_:deepdarkestspawn", "callfromthedepth_:deepdarkestspwansecondphase", "minecraft:zombie", "minecraft:husk", "minecraft:drowned", "minecraft:skeleton", "minecraft:wither_skeleton", "minecraft:stray", "mowziesmobs:umvuthana", "mowziesmobs:umvuthana_raptor", "mowziesmobs:umvuthana_crane", "quark:forgotten")), o -> o instanceof String);
        ANTI_SEAT_ENTITY_CONFIG = builder.build();
    }
}

