/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.ClientProxy;
import com.bobmowzie.mowziesmobs.client.gui.CustomBossBar;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerThirdPerson;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.client.render.block.SculptorBlockMarking;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.client.sound.BossMusicPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.item.ItemBlowgun;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventHandler {
    INSTANCE;

    private static final ResourceLocation FROZEN_BLUR;
    private static ResourceLocation SCULPTOR_BLOCK_GLOW;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHandRender(RenderHandEvent event) {
        GeckoPlayer.GeckoPlayerFirstPerson geckoPlayer;
        PlayerCapability.IPlayerCapability playerCapability;
        if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        boolean shouldAnimate = false;
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability != null) {
            boolean bl = shouldAnimate = abilityCapability.getActiveAbility() != null;
        }
        if (shouldAnimate && (playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY)) != null && (geckoPlayer = GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON) != null) {
            ModelGeckoPlayerFirstPerson geckoFirstPersonModel = (ModelGeckoPlayerFirstPerson)geckoPlayer.getModel();
            GeckoFirstPersonRenderer firstPersonRenderer = (GeckoFirstPersonRenderer)geckoPlayer.getPlayerRenderer();
            if (geckoFirstPersonModel != null && firstPersonRenderer != null) {
                if (!geckoFirstPersonModel.isUsingSmallArms() && ((AbstractClientPlayer)player).m_108564_().equals("slim")) {
                    firstPersonRenderer.setSmallArms();
                }
                event.setCanceled(true);
                if (event.isCanceled()) {
                    float delta = event.getPartialTick();
                    float f1 = Mth.m_14179_((float)delta, (float)player.f_19860_, (float)player.m_146909_());
                    firstPersonRenderer.renderItemInFirstPerson((AbstractClientPlayer)player, f1, delta, event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEvent(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        if (event.getEntity() instanceof Player) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
            PlayerCapability.IPlayerCapability playerCapability;
            if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue()) {
                return;
            }
            Player player = (Player)event.getEntity();
            if (player == null) {
                return;
            }
            if (((Boolean)ConfigHandler.CLIENT.hidePlayerAnimsInFirstPerson.get()).booleanValue() && player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                return;
            }
            float delta = event.getPartialTick();
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
            if (abilityCapability != null && abilityCapability.getActiveAbility() != null && (playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY)) != null && (geckoPlayer = playerCapability.getGeckoPlayer()) != null) {
                ModelGeckoPlayerThirdPerson geckoPlayerModel = (ModelGeckoPlayerThirdPerson)geckoPlayer.getModel();
                GeckoRenderPlayer animatedPlayerRenderer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                if (geckoPlayerModel != null && animatedPlayerRenderer != null) {
                    event.setCanceled(true);
                    if (event.isCanceled()) {
                        animatedPlayerRenderer.render((AbstractClientPlayer)event.getEntity(), event.getEntity().m_146908_(), delta, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), geckoPlayer);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        Player player = event.player;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null && event.side == LogicalSide.CLIENT) {
            GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer = playerCapability.getGeckoPlayer();
            if (geckoPlayer != null) {
                geckoPlayer.tick();
            }
            if (player == Minecraft.m_91087_().f_91074_) {
                GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON.tick();
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.FROZEN_CAPABILITY);
        if (frozenCapability != null && frozenCapability.getFrozen() && frozenCapability.getPrevFrozen()) {
            player.m_146922_(frozenCapability.getFrozenYaw());
            player.m_146926_(frozenCapability.getFrozenPitch());
            player.f_20885_ = frozenCapability.getFrozenYawHead();
            player.f_19859_ = player.m_146908_();
            player.f_19860_ = player.m_146909_();
            player.f_20886_ = player.f_20885_;
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.FROZEN_CAPABILITY);
        if (frozenCapability != null && frozenCapability.getFrozen() && frozenCapability.getPrevFrozen()) {
            entity.f_19859_ = frozenCapability.getFrozenYaw();
            entity.m_146922_(entity.f_19859_);
            entity.f_19860_ = frozenCapability.getFrozenPitch();
            entity.m_146926_(entity.f_19860_);
            entity.f_20885_ = entity.f_20886_ = frozenCapability.getFrozenYawHead();
            entity.f_20883_ = entity.f_20884_ = frozenCapability.getFrozenRenderYawOffset();
            entity.f_20921_ = entity.f_20920_ = frozenCapability.getFrozenSwingProgress();
            entity.f_267362_.m_267771_(frozenCapability.getFrozenWalkAnimSpeed());
            entity.f_267362_.f_267358_ = frozenCapability.getFrozenWalkAnimPosition();
            entity.m_20260_(false);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Post e) {
        FrozenCapability.IFrozenCapability frozenCapability;
        int startTime = 210;
        int pointStart = 1200;
        int timePerMillis = 22;
        if (e.getOverlay() == VanillaGuiOverlay.FROSTBITE.type() && Minecraft.m_91087_().f_91074_ != null && (frozenCapability = CapabilityHandler.getCapability((Entity)Minecraft.m_91087_().f_91074_, CapabilityHandler.FROZEN_CAPABILITY)) != null && frozenCapability.getFrozen() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            Window res = e.getWindow();
            e.getGuiGraphics().m_280163_(FROZEN_BLUR, 0, 0, 0.0f, 0.0f, res.m_85445_(), res.m_85446_(), res.m_85445_(), res.m_85446_());
        }
    }

    @SubscribeEvent
    public void onRenderHUD(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20159_() && player.m_20202_() instanceof EntityFrozenController) {
            if (event.getOverlay() == VanillaGuiOverlay.MOUNT_HEALTH.type()) {
                event.setCanceled(true);
            }
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237119_(), false);
        }
    }

    @SubscribeEvent
    public void updateFOV(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.m_6117_() && player.m_21211_().m_41720_() instanceof ItemBlowgun) {
            int i = player.m_21252_();
            float f1 = (float)i / 5.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewFovModifier(1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null && ((Boolean)ConfigHandler.CLIENT.doCameraShakes.get()).booleanValue() && !Minecraft.m_91087_().m_91104_()) {
            float shakeAmplitude = 0.0f;
            for (EntityCameraShake cameraShake : player.m_9236_().m_45976_(EntityCameraShake.class, player.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (!((Boolean)ConfigHandler.CLIENT.customBossBars.get()).booleanValue()) {
            return;
        }
        ResourceLocation bossRegistryName = ClientProxy.bossBarRegistryNames.getOrDefault(event.getBossEvent().m_18860_(), null);
        if (bossRegistryName == null) {
            return;
        }
        CustomBossBar customBossBar = CustomBossBar.customBossBars.getOrDefault(bossRegistryName, null);
        if (customBossBar == null) {
            return;
        }
        event.setCanceled(true);
        customBossBar.renderBossBar(event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (Minecraft.m_91087_().f_91074_ != null && level != null && level.getModelDataManager() != null) {
                Vec3 cameraPos = event.getCamera().m_90583_();
                double d0 = cameraPos.m_7096_();
                double d1 = cameraPos.m_7098_();
                double d2 = cameraPos.m_7094_();
                for (Long2ObjectMap.Entry entry : ClientProxy.sculptorMarkedBlocks.long2ObjectEntrySet()) {
                    BlockPos blockpos2 = BlockPos.m_122022_((long)entry.getLongKey());
                    SculptorBlockMarking blockMarking = (SculptorBlockMarking)entry.getValue();
                    float alpha = 1.0f - (float)blockMarking.getTicks() / (float)blockMarking.getDuration();
                    event.getPoseStack().m_85836_();
                    event.getPoseStack().m_85837_((double)blockpos2.m_123341_() - d0, (double)blockpos2.m_123342_() - d1, (double)blockpos2.m_123343_() - d2);
                    PoseStack.Pose posestack$pose1 = event.getPoseStack().m_85850_();
                    float f = (float)Minecraft.m_91087_().f_91074_.f_19797_ + Minecraft.m_91087_().getPartialTick();
                    float blockOffset = (float)(blockpos2.m_123341_() + blockpos2.m_123342_() + blockpos2.m_123343_()) * 0.25f;
                    SheetedDecalTextureGenerator vertexconsumer1 = new SheetedDecalTextureGenerator(Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(MMRenderType.highlight(SCULPTOR_BLOCK_GLOW, f * 0.02f + blockOffset, f * 0.01f + blockOffset)), posestack$pose1.m_252922_(), posestack$pose1.m_252943_(), 0.25f);
                    ModelData modelData = level.getModelDataManager().getAt(blockpos2);
                    this.renderBreakingTexture(level.m_8055_(blockpos2), blockpos2, (BlockAndTintGetter)level, event.getPoseStack(), level.f_46441_, (VertexConsumer)vertexconsumer1, modelData == null ? ModelData.EMPTY : modelData);
                    event.getPoseStack().m_85849_();
                }
            }
        }
    }

    private void renderBreakingTexture(BlockState state, BlockPos pos, BlockAndTintGetter blockAndTintGetter, PoseStack poseStack, RandomSource random, VertexConsumer vertexConsumer, ModelData modelData) {
        if (state.m_60799_() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel bakedmodel = blockRenderDispatcher.m_110910_(state);
            long i = state.m_60726_(pos);
            blockRenderDispatcher.m_110937_().tesselateBlock(blockAndTintGetter, bakedmodel, state, pos, poseStack, vertexConsumer, true, random, i, OverlayTexture.f_118083_, modelData, null);
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END) {
            MowziesMobs.PROXY.updateMarkedBlocks();
            BossMusicPlayer.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInteractionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        PlayerCapability.IPlayerCapability playerCapability;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.getKeyMapping() == Minecraft.m_91087_().f_91066_.f_92096_) {
            PlayerCapability.IPlayerCapability playerCapability2 = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
            if (playerCapability2 != null) {
                playerCapability2.pressedAttackKey((Player)player);
            }
        } else if (event.getKeyMapping() == Minecraft.m_91087_().f_91066_.f_92095_ && (playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY)) != null) {
            playerCapability.pressedUseKey((Player)player);
        }
    }

    static {
        FROZEN_BLUR = new ResourceLocation("textures/misc/powder_snow_outline.png");
        SCULPTOR_BLOCK_GLOW = new ResourceLocation("mowziesmobs", "textures/entity/sculptor_highlight.png");
    }
}

