/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.network;

import com.havnnek.style_combat.client.PlayerStyleData;
import com.havnnek.style_combat.client.StyleScoringManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class S2CUpdateStyleData {
    private final int stylePoints;
    private final int comboCount;
    private final String rank;

    public S2CUpdateStyleData(ServerPlayer player) {
        PlayerStyleData d = StyleScoringManager.get((Player)player);
        if (d != null) {
            this.stylePoints = d.getStylePoints();
            this.comboCount = d.getComboCount();
            this.rank = d.getRank();
        } else {
            this.stylePoints = 0;
            this.comboCount = 0;
            this.rank = "D";
        }
    }

    public S2CUpdateStyleData(int stylePoints, int comboCount, String rank) {
        this.stylePoints = stylePoints;
        this.comboCount = comboCount;
        this.rank = rank;
    }

    public static void encode(S2CUpdateStyleData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.stylePoints);
        buf.writeInt(msg.comboCount);
        buf.m_130070_(msg.rank);
    }

    public static S2CUpdateStyleData decode(FriendlyByteBuf buf) {
        int stylePoints = buf.readInt();
        int comboCount = buf.readInt();
        String rank = buf.m_130277_();
        return new S2CUpdateStyleData(stylePoints, comboCount, rank);
    }

    public static void handle(S2CUpdateStyleData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                StyleScoringManager.applyClientSync(msg.stylePoints, msg.comboCount, msg.rank);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

