/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.network;

import com.havnnek.style_combat.network.S2CUpdateStyleData;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL = "1";
    private static final AtomicInteger ID = new AtomicInteger(0);
    public static SimpleChannel CHANNEL;

    public static void init() {
        if (CHANNEL != null) {
            return;
        }
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("havns_style_combat", "net"), () -> PROTOCOL, PROTOCOL::equals, PROTOCOL::equals);
        NetworkHandler.registerPacket(S2CUpdateStyleData.class, S2CUpdateStyleData::encode, S2CUpdateStyleData::decode, S2CUpdateStyleData::handle);
    }

    private static <MSG> void registerPacket(Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
        int id = ID.getAndIncrement();
        CHANNEL.registerMessage(id, type, encoder, decoder, (msg, ctxSupplier) -> {
            handler.accept((Object)msg, (Supplier<NetworkEvent.Context>)ctxSupplier);
            ((NetworkEvent.Context)ctxSupplier.get()).setPacketHandled(true);
        });
    }

    public static void sendToPlayer(Object packet, ServerPlayer player) {
        if (player == null || CHANNEL == null) {
            return;
        }
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    public static void sync(ServerPlayer player) {
        if (player == null || CHANNEL == null) {
            return;
        }
        S2CUpdateStyleData packet = new S2CUpdateStyleData(player);
        NetworkHandler.sendToPlayer(packet, player);
    }
}

