/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.event;

import com.havnnek.style_combat.api.datapack.DataPackDrivenRuleManager;
import com.havnnek.style_combat.client.PlayerStyleData;
import com.havnnek.style_combat.client.StyleScoringManager;
import com.havnnek.style_combat.client.renderer.ClientOverlayRenderer;
import com.havnnek.style_combat.config.StyleCombatConfig;
import com.havnnek.style_combat.network.NetworkHandler;
import com.havnnek.style_combat.server.command.StyleCombatCommand;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.EntityStunEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@Mod.EventBusSubscriber
public class SSEventHandler {
    private static final UUID EVENT_UUID = UUID.fromString("0439d1c1-2362-449b-8382-2a356267932a");
    private static final WeakHashMap<LivingEntity, Long> lastProjectileHit = new WeakHashMap();
    private static final WeakHashMap<Player, Long> lastShieldBlock = new WeakHashMap();
    private static final WeakHashMap<Player, ArsenalTracker> arsenalMap = new WeakHashMap();

    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        DamageSource source = event.getSource();
        if (source.m_7639_() instanceof Player && event.getEntity() instanceof LivingEntity) {
            ServerPlayer sp;
            Player player = (Player)source.m_7639_();
            LivingEntity target = event.getEntity();
            int basePoints = (Integer)StyleCombatConfig.KILL_POINTS.get();
            String actionText = "+ Kill";
            int color = -1;
            if (source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268448_)) {
                if (!target.m_20096_()) {
                    basePoints += ((Integer)StyleCombatConfig.FIREWORK_POINTS.get()).intValue();
                    actionText = "+ Firework";
                    color = -39169;
                } else {
                    basePoints += ((Integer)StyleCombatConfig.EXPLOSION_POINTS.get()).intValue();
                    actionText = "+ Explode";
                    color = -16711936;
                }
            } else if (source.m_269533_(EpicFightDamageTypeTags.EXECUTION)) {
                basePoints += ((Integer)StyleCombatConfig.EXECUTION_KILL_POINTS.get()).intValue();
                actionText = "+ Execution";
                color = -3355444;
            } else if (source.m_269533_(EpicFightDamageTypeTags.FINISHER)) {
                basePoints += ((Integer)StyleCombatConfig.FINISHER_POINTS.get()).intValue();
                actionText = "+ Finisher";
                color = -16711681;
            }
            ArsenalTracker tracker = arsenalMap.computeIfAbsent(player, p -> new ArsenalTracker());
            long now = System.currentTimeMillis();
            if (now - tracker.lastKillTime > (long)((Integer)StyleCombatConfig.ARSENAL_RESET_TIME.get()).intValue()) {
                tracker.weapons.clear();
            }
            tracker.lastKillTime = now;
            String weaponId = player.m_21205_().m_41619_() ? "fist" : player.m_21205_().m_41720_().m_5524_();
            tracker.weapons.add(weaponId);
            if (tracker.weapons.size() >= 3) {
                StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.ARSENAL_POINTS.get());
                ClientOverlayRenderer.addActionText("+ Arsenal", -15732737);
                tracker.weapons.clear();
                if (player instanceof ServerPlayer) {
                    sp = (ServerPlayer)player;
                    NetworkHandler.sync(sp);
                }
            }
            StyleScoringManager.addKillStyle(player, basePoints);
            ClientOverlayRenderer.addActionText(actionText, color);
            if (player instanceof ServerPlayer) {
                sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
            DataPackDrivenRuleManager.get().onKillTrigger(player);
            PlayerStyleData data = StyleScoringManager.get(player);
            player.m_5661_((Component)Component.m_237113_((String)("Rank: " + data.getRank() + " (" + data.getStylePoints() + " pts)")), true);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (event.isVanillaCritical()) {
            StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.CRITICAL_HIT_POINTS.get());
            ClientOverlayRenderer.addActionText("+ Critical Hit", -1);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
        }
    }

    @SubscribeEvent
    public static void onUseTotem(LivingUseTotemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.TOTEM_USE_POINTS.get());
        ClientOverlayRenderer.addActionText("+ Resurrection", -10496);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sync(sp);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        PlayerStyleData data = StyleScoringManager.get(player);
        if (data != null) {
            data.setStylePoints(0);
            data.resetCombo();
            data.resetHitTaken();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        DamageSource src = event.getSource();
        if (src.m_276093_(DamageTypes.f_268739_) || src.m_276093_(DamageTypes.f_268714_) || src.m_269533_(DamageTypeTags.f_268524_)) {
            LivingEntity target = event.getEntity();
            long now = System.currentTimeMillis();
            int cd = (Integer)StyleCombatConfig.PROJECTILE_HIT_COOLDOWN.get();
            Long lastTime = lastProjectileHit.get(target);
            if (lastTime == null || now - lastTime > (long)cd) {
                lastProjectileHit.put(target, now);
                StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.PROJECTILE_HIT_POINTS.get());
                ClientOverlayRenderer.addActionText("+ Projectile Hit", -1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkHandler.sync(sp);
                }
            }
        }
        DataPackDrivenRuleManager.get().onDamageTrigger(player);
    }

    @SubscribeEvent
    public static void onEntityStunned(EntityStunEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (event.getStunType() == StunType.NEUTRALIZE) {
            StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.STUN_NEUTRALIZE_POINTS.get());
            ClientOverlayRenderer.addActionText("+ Guard Break", -16711681);
        } else if (event.getStunType() == StunType.KNOCKDOWN) {
            StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.STUN_KNOCKDOWN_POINTS.get());
            ClientOverlayRenderer.addActionText("+ Knockdown", -721024);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sync(sp);
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(ShieldBlockEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        long now = System.currentTimeMillis();
        int cd = (Integer)StyleCombatConfig.SHIELD_BLOCK_COOLDOWN.get();
        Long lastTime = lastShieldBlock.get(player);
        if (lastTime == null || now - lastTime > (long)cd) {
            lastShieldBlock.put(player, now);
            StyleScoringManager.addKillStyle(player, (Integer)StyleCombatConfig.SHIELD_BLOCKED_POINTS.get());
            ClientOverlayRenderer.addActionText("+ Blocked", -3355444);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onPlayerDamaged(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        PlayerStyleData data = StyleScoringManager.get(player);
        if (data != null) {
            data.onPlayerHit();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            StyleScoringManager.tickAll();
            Player player = event.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sync(sp);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        StyleCombatCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void attachEpicFightListeners(Player player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch != null) {
            playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
            playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
            playerPatch.getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_END_EVENT, EVENT_UUID);
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, e -> {
                StyleScoringManager.get(player).addComboHit((Integer)StyleCombatConfig.COMBO_POINTS.get());
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkHandler.sync(sp);
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, e -> {
                if (e.isParried()) {
                    StyleScoringManager.addKillStyle((Player)((ServerPlayerPatch)e.getPlayerPatch()).getOriginal(), (Integer)StyleCombatConfig.PARRY_POINTS.get());
                    ClientOverlayRenderer.addActionText("+ Parry", -11141121);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        NetworkHandler.sync(sp);
                    }
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, e -> {
                StyleScoringManager.addKillStyle((Player)((ServerPlayerPatch)e.getPlayerPatch()).getOriginal(), (Integer)StyleCombatConfig.DODGE_POINTS.get());
                ClientOverlayRenderer.addActionText("+ Dodge", -1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    NetworkHandler.sync(sp);
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, e -> {
                StaticAnimation anim = e.getAnimation();
                if (anim != null && anim.getRegistryName() != null) {
                    String animKey = anim.getRegistryName() != null ? anim.getRegistryName().toString() : null;
                    ResourceLocation animId = anim.getRegistryName();
                    DataPackDrivenRuleManager.get().onAnimationPlay(player, animId);
                    DataPackDrivenRuleManager.get().setActiveAnimation(player, anim);
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_END_EVENT, EVENT_UUID, e -> DataPackDrivenRuleManager.get().clearActiveAnimation(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        SSEventHandler.attachEpicFightListeners(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sync(sp);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        SSEventHandler.attachEpicFightListeners(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHandler.sync(sp);
        }
    }

    private static class ArsenalTracker {
        Set<String> weapons = new HashSet<String>();
        long lastKillTime = System.currentTimeMillis();

        private ArsenalTracker() {
        }
    }
}

