/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class StyleCombatConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec.IntValue MAX_POINTS;
    public static final ForgeConfigSpec.IntValue COMBO_POINTS;
    public static final ForgeConfigSpec.IntValue KILL_POINTS;
    public static final ForgeConfigSpec.IntValue PARRY_POINTS;
    public static final ForgeConfigSpec.IntValue DODGE_POINTS;
    public static final ForgeConfigSpec.IntValue EXPLOSION_POINTS;
    public static final ForgeConfigSpec.IntValue PROJECTILE_HIT_POINTS;
    public static final ForgeConfigSpec.IntValue SHIELD_BLOCKED_POINTS;
    public static final ForgeConfigSpec.IntValue CRITICAL_HIT_POINTS;
    public static final ForgeConfigSpec.IntValue TOTEM_USE_POINTS;
    public static final ForgeConfigSpec.IntValue STUN_NEUTRALIZE_POINTS;
    public static final ForgeConfigSpec.IntValue STUN_KNOCKDOWN_POINTS;
    public static final ForgeConfigSpec.IntValue EXECUTION_KILL_POINTS;
    public static final ForgeConfigSpec.IntValue FINISHER_POINTS;
    public static final ForgeConfigSpec.IntValue FIREWORK_POINTS;
    public static final ForgeConfigSpec.IntValue ARSENAL_POINTS;
    public static final ForgeConfigSpec.IntValue TIME_DECREASE_POINTS;
    public static final ForgeConfigSpec.IntValue POINTS_DECREASE_EACH_MILIS;
    public static final ForgeConfigSpec.IntValue COMBO_IN_TIME;
    public static final ForgeConfigSpec.IntValue BONUS_POINTS_IN_COMBO;
    public static final ForgeConfigSpec.IntValue MAX_BONUS_POINTS_IN_COMBO;
    public static final ForgeConfigSpec.IntValue COMBO_TIME_RESET;
    public static final ForgeConfigSpec.IntValue HIGH_RANK_DECAY_POINTS;
    public static final ForgeConfigSpec.IntValue HIT_TAKEN_BASE_PENALTY;
    public static final ForgeConfigSpec.IntValue HIT_TAKEN_STACK_PENALTY;
    public static final ForgeConfigSpec.IntValue HIT_TAKEN_COMBO_TIME;
    public static final ForgeConfigSpec.IntValue RANK_C_THRESHOLD;
    public static final ForgeConfigSpec.IntValue RANK_B_THRESHOLD;
    public static final ForgeConfigSpec.IntValue RANK_A_THRESHOLD;
    public static final ForgeConfigSpec.IntValue RANK_S_THRESHOLD;
    public static final ForgeConfigSpec.IntValue RANK_SS_THRESHOLD;
    public static final ForgeConfigSpec.IntValue RANK_SSS_THRESHOLD;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_C;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_B;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_A;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_S;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_SS;
    public static final ForgeConfigSpec.IntValue POINTS_NEXT_SSS;
    public static final ForgeConfigSpec.IntValue PROJECTILE_HIT_COOLDOWN;
    public static final ForgeConfigSpec.IntValue SHIELD_BLOCK_COOLDOWN;
    public static final ForgeConfigSpec.IntValue ARSENAL_RESET_TIME;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General Settings").push("general");
        MAX_POINTS = builder.comment("Maximum style points (SSS cap).").defineInRange("maxPoints", 4500, 1000, 100000);
        builder.pop();
        builder.push("Scoring");
        COMBO_POINTS = builder.comment("Points awarded for each combo").comment("").defineInRange("comboPoints", 10, 0, 5000);
        KILL_POINTS = builder.comment("Points awarded for each kill").comment("").defineInRange("killPoints", 125, 0, 5000);
        PARRY_POINTS = builder.comment("Points awarded for successful parry").comment("").defineInRange("parryPoints", 160, 0, 5000);
        DODGE_POINTS = builder.comment("Points awarded for successful dodge").comment("").defineInRange("dodgePoints", 90, 0, 5000);
        EXPLOSION_POINTS = builder.comment("Points awarded for kiling entity by Explosion Sources").comment("").defineInRange("explosionPoints", 300, 0, 5000);
        PROJECTILE_HIT_POINTS = builder.comment("Points awarded for projectile hit").comment("").defineInRange("projectileHitPoints", 50, 0, 5000);
        SHIELD_BLOCKED_POINTS = builder.comment("Points awarded for blocking by using shield successfully").comment("").defineInRange("shieldBlockedPoints", 35, 0, 5000);
        CRITICAL_HIT_POINTS = builder.comment("Points gained when performing a critical hit").defineInRange("criticalHitPoints", 30, 0, 10000);
        TOTEM_USE_POINTS = builder.comment("Points gained when using a Totem of Undying").defineInRange("totemUsePoints", 500, 0, 10000);
        STUN_KNOCKDOWN_POINTS = builder.comment("Points gained when stun mob by 'StunType.KNOCKDOWN'").defineInRange("stunKnockdownPoints", 200, 0, 10000);
        STUN_NEUTRALIZE_POINTS = builder.comment("Points gained when guard break or stun mob by 'StunType.NEUTRALIZE'").defineInRange("stunNeutralizePoints", 175, 0, 10000);
        EXECUTION_KILL_POINTS = builder.comment("Points awarded for executed enemy (DamageTypes Tags from EF: EXECUTION)").defineInRange("executionKillPoints", 250, 0, 1000);
        FINISHER_POINTS = builder.comment("Points awarded for finishing enemy (DamageTypes Tags from EF: FINISHER)").defineInRange("finisherKillPoints", 150, 0, 1000);
        FIREWORK_POINTS = builder.comment("Points awarded for Firework kill (Kill mob on the airborne with EXPLOSION Damage)").defineInRange("fireworkPoints", 400, 0, 1000);
        ARSENAL_POINTS = builder.comment("Points awarded for Arsenal kill (killing with multiple weapons)").defineInRange("arsenalPoints", 225, 0, 1000);
        builder.pop();
        builder.push("Style Data");
        TIME_DECREASE_POINTS = builder.comment("How long do point decrease? (Count as Milis, For Example: 1000Milis = 1s)").comment("").defineInRange("timeDecreasePoints", 50, 0, 100000);
        POINTS_DECREASE_EACH_MILIS = builder.comment("How many points decrease each Milis? (Count as Milis, For Ex: I set: 1000Milis Decrease 20 points)").comment("").defineInRange("pointsDecreaseEachMilis", 1, 0, 1000);
        COMBO_IN_TIME = builder.comment("Combo in time (Count as Milis, Ex: If you perform combo in 2.5s (default) you will get bonus points, after 2.5s bonus points + combos reset!)").comment("").defineInRange("comboInTime", 2500, 0, 100000);
        BONUS_POINTS_IN_COMBO = builder.comment("Bonus points in combo (Ex: In 2.5s (default) combo, you get bonus points each combo you do! (For EX: Combo x2 = +5 points bonuses); after 2s (default), bonus points reset to 5)").comment("").defineInRange("bonusPointsInCombo", 5, 0, 100);
        MAX_BONUS_POINTS_IN_COMBO = builder.comment("Maximum bonus points from combos (prevents infinite stacking).").defineInRange("maxBonusPointsInCombo", 40, 0, 1000);
        COMBO_TIME_RESET = builder.comment("How long do combos reset (Count as Milis, For Ex: 3000Milis = 3s)").comment("").defineInRange("comboTimeReset", 2500, 0, 100000);
        builder.pop();
        builder.push("Decrease Points System");
        HIGH_RANK_DECAY_POINTS = builder.comment("Decay points lost per tick when rank is S or higher (Set 1 is disable this option)").defineInRange("highRankDecayMultiplier", 2, 1, 100);
        HIT_TAKEN_BASE_PENALTY = builder.comment("Base points lost when hit (default: 50)").defineInRange("hit_taken_base_penalty", 50, 0, 500);
        HIT_TAKEN_STACK_PENALTY = builder.comment("Additional points lost for each consecutive hit (default: 10)").defineInRange("hit_taken_stack_penalty", 10, 0, 500);
        HIT_TAKEN_COMBO_TIME = builder.comment("Time window in ms to count consecutive hits (default 2000ms = 2s)").defineInRange("hit_taken_combo_time", 2000, 100, 10000);
        builder.pop();
        builder.push("Rank Points Threshold (Advanced Setting)");
        RANK_C_THRESHOLD = builder.comment("Points required to reach rank C").defineInRange("rank.threshold.c", 400, 0, Integer.MAX_VALUE);
        RANK_B_THRESHOLD = builder.comment("Points required to reach rank B").defineInRange("rank.threshold.b", 900, 0, Integer.MAX_VALUE);
        RANK_A_THRESHOLD = builder.comment("Points required to reach rank A").defineInRange("rank.threshold.a", 1400, 0, Integer.MAX_VALUE);
        RANK_S_THRESHOLD = builder.comment("Points required to reach rank S").defineInRange("rank.threshold.s", 2000, 0, Integer.MAX_VALUE);
        RANK_SS_THRESHOLD = builder.comment("Points required to reach rank SS").defineInRange("rank.threshold.ss", 2700, 0, Integer.MAX_VALUE);
        RANK_SSS_THRESHOLD = builder.comment("Points required to reach rank SSS").defineInRange("rank.threshold.sss", 3500, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Rank for Next Points (Advanced Setting)");
        POINTS_NEXT_C = builder.comment("Points needed in rank C to reach B").defineInRange("rank.pointsnext.c", 500, 0, Integer.MAX_VALUE);
        POINTS_NEXT_B = builder.comment("Points needed in rank B to reach A").defineInRange("rank.pointsnext.b", 500, 0, Integer.MAX_VALUE);
        POINTS_NEXT_A = builder.comment("Points needed in rank A to reach S").defineInRange("rank.pointsnext.a", 600, 0, Integer.MAX_VALUE);
        POINTS_NEXT_S = builder.comment("Points needed in rank S to reach SS").defineInRange("rank.pointsnext.s", 700, 0, Integer.MAX_VALUE);
        POINTS_NEXT_SS = builder.comment("Points needed in rank SS to reach SSS").defineInRange("rank.pointsnext.ss", 800, 0, Integer.MAX_VALUE);
        POINTS_NEXT_SSS = builder.comment("Extra points in SSS rank (cap)").defineInRange("rank.pointsnext.sss", 1000, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.push("Other");
        PROJECTILE_HIT_COOLDOWN = builder.comment("Cooldown time in ms for projectile hit scoring per entity (Default: 1500ms)").defineInRange("projectileHitCooldown", 1500, 0, 100000);
        SHIELD_BLOCK_COOLDOWN = builder.comment("Cooldown (ms) before shield block can give points again. (Default: 1000ms").defineInRange("shieldBlockCooldown", 500, 0, 60000);
        ARSENAL_RESET_TIME = builder.comment("Reset time for Arsenal weapon tracking (ms)").defineInRange("arsenalResetTime", 6000, 1000, 60000);
        builder.pop();
        COMMON_SPEC = builder.build();
    }
}

