/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.client.renderer;

import com.havnnek.style_combat.client.ClientKeyHandler;
import com.havnnek.style_combat.client.PlayerStyleData;
import com.havnnek.style_combat.client.StyleScoringManager;
import com.havnnek.style_combat.client.renderer.ActionTextRenderer;
import com.havnnek.style_combat.config.StyleCombatClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="havns_style_combat", value={Dist.CLIENT})
public class ClientOverlayRenderer {
    private static final List<ActionTextRenderer> actionTexts = new ArrayList<ActionTextRenderer>();
    private static long lastComboTime = 0L;
    private static int lastComboValue = 0;
    private static long lastActiveTime = System.currentTimeMillis();
    private static float hudAlpha = 1.0f;

    public static void addActionText(String text, int color) {
        actionTexts.add(new ActionTextRenderer(text, color));
        if (actionTexts.size() > (Integer)StyleCombatClientConfig.ACTION_TEXT_MAX_TEXT.get()) {
            actionTexts.remove(0);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        float progress;
        if (!event.getOverlay().id().toString().equals("minecraft:hotbar")) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            return;
        }
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (!(mc.f_91074_ instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PlayerStyleData data = StyleScoringManager.getClientData();
        if (data == null) {
            return;
        }
        String rank = data.getRank();
        if (data.getStylePoints() > 0 || data.getComboCount() > 0) {
            lastActiveTime = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        long inactiveTime = now - lastActiveTime;
        int timeout = (Integer)StyleCombatClientConfig.HUD_INACTIVE_TIMEOUT.get();
        int fadeDuration = (Integer)StyleCombatClientConfig.HUD_FADE_DURATION.get();
        if (inactiveTime < (long)timeout) {
            hudAlpha = 1.0f;
        } else if (inactiveTime < (long)(timeout + fadeDuration)) {
            float progress2 = (float)(inactiveTime - (long)timeout) / (float)fadeDuration;
            hudAlpha = 1.0f - Math.min(1.0f, progress2);
        } else {
            hudAlpha = 0.0f;
        }
        if (hudAlpha <= 0.01f) {
            return;
        }
        if (!ClientKeyHandler.isHudToggled()) {
            return;
        }
        if (!((Boolean)StyleCombatClientConfig.HUD_ENABLED.get()).booleanValue()) {
            return;
        }
        int screenWidth = mc.m_91268_().m_85445_();
        int boxWidth = (Integer)StyleCombatClientConfig.HUD_WIDTH.get();
        int boxHeight = (Integer)StyleCombatClientConfig.HUD_HEIGHT.get();
        int x = screenWidth - boxWidth - (Integer)StyleCombatClientConfig.HUD_X.get();
        int y = (Integer)StyleCombatClientConfig.HUD_Y.get();
        if (((Boolean)StyleCombatClientConfig.HUD_SHOW_BACKGROUND_BOX.get()).booleanValue()) {
            guiGraphics.m_280509_(x, y, x + boxWidth, y + boxHeight, -1442840576);
        }
        ResourceLocation rankIcon = switch (rank) {
            case "SSS" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_sss.png");
            case "SS" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_ss.png");
            case "S" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_s.png");
            case "A" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_a.png");
            case "B" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_b.png");
            case "C" -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_c.png");
            default -> new ResourceLocation("havns_style_combat", "textures/gui/rank_icon/rank_d.png");
        };
        int iconSize = (Integer)StyleCombatClientConfig.HUD_RANK_ICON_SIZE.get();
        guiGraphics.m_280163_(rankIcon, x + 8, y + 6, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        if (((Boolean)StyleCombatClientConfig.HUD_SHOW_RANK_NICKNAME.get()).booleanValue()) {
            int offsetNX;
            String nickname;
            int offsetNY = switch (rank) {
                case "SSS" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_SSS.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_SSS.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_SSS.get();
                }
                case "SS" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_SS.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_SS.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_SS.get();
                }
                case "S" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_S.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_S.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_S.get();
                }
                case "A" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_A.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_A.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_A.get();
                }
                case "B" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_B.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_B.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_B.get();
                }
                case "C" -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_C.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_C.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_C.get();
                }
                default -> {
                    nickname = (String)StyleCombatClientConfig.HUD_TEXT_D.get();
                    offsetNX = (Integer)StyleCombatClientConfig.HUD_OFFSET_X_D.get();
                    yield (Integer)StyleCombatClientConfig.HUD_OFFSET_Y_D.get();
                }
            };
            float scale = ((Integer)StyleCombatClientConfig.HUD_RANK_NICKNAME_SIZE.get()).intValue();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280056_(mc.f_91062_, nickname, (int)((float)(x + 8 + offsetNX) / scale), (int)((float)(y + 6 + offsetNY) / scale), -1, false);
            guiGraphics.m_280168_().m_85849_();
        }
        int barX = x + 8;
        int barY = y + 12 + iconSize;
        int barWidth = boxWidth - 16;
        int barHeight = 5;
        int current = data.getPointsInCurrentRank();
        int max = data.getPointsForNextRank();
        float f = progress = max > 0 ? (float)current / (float)max : 1.0f;
        if (rank.equals("SSS")) {
            progress = 1.0f;
            double time = (double)System.currentTimeMillis() / 500.0;
            float brightness = (float)((Math.sin(time) + 1.0) / 2.0);
            int baseColor = -65536;
            int glowColor = -171;
            int r = (int)((float)(baseColor >> 16 & 0xFF) + (float)((glowColor >> 16 & 0xFF) - (baseColor >> 16 & 0xFF)) * brightness);
            int g = (int)((float)(baseColor >> 8 & 0xFF) + (float)((glowColor >> 8 & 0xFF) - (baseColor >> 8 & 0xFF)) * brightness);
            int b = (int)((float)(baseColor & 0xFF) + (float)((glowColor & 0xFF) - (baseColor & 0xFF)) * brightness);
            int finalColor = 0xFF000000 | r << 16 | g << 8 | b;
            guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, 0x66000000);
            guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, finalColor);
        } else {
            int filled = (int)((float)barWidth * progress);
            guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -11184811);
            guiGraphics.m_280509_(barX, barY, barX + filled, barY + barHeight, -1);
        }
        if (((Boolean)StyleCombatClientConfig.HUD_SHOW_POINTS_TEXT.get()).booleanValue()) {
            String barText = current + " / " + max;
            guiGraphics.m_280056_(mc.f_91062_, barText, barX + 2, barY - 10, 0xCCCCCC, false);
        }
        long nowTime = System.currentTimeMillis();
        long duration = ((Integer)StyleCombatClientConfig.ACTION_TEXT_FADING_OUT.get()).intValue();
        int offset = 0;
        for (ActionTextRenderer at : new ArrayList<ActionTextRenderer>(actionTexts)) {
            if (at.isExpired(nowTime, duration)) {
                actionTexts.remove(at);
                continue;
            }
            float alpha = at.getAlpha(nowTime, duration) * hudAlpha;
            int a = (int)(alpha * 255.0f);
            if (a <= 0) continue;
            int color = a << 24 | at.color & 0xFFFFFF;
            float scale = at.getScale();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280056_(mc.f_91062_, at.text, (int)((float)(barX + (Integer)StyleCombatClientConfig.ACTION_TEXT_OFFSET_X.get()) / scale), (int)((float)(barY + (Integer)StyleCombatClientConfig.ACTION_TEXT_OFFSET_Y.get() + offset) / scale), color, false);
            guiGraphics.m_280168_().m_85849_();
            offset += (int)(10.0f * scale);
        }
        int combo = data.getComboCount();
        if (combo > 0) {
            if (combo != lastComboValue) {
                lastComboValue = combo;
                lastComboTime = System.currentTimeMillis();
            }
            long elapsed = System.currentTimeMillis() - lastComboTime;
            int shakeX = 0;
            int shakeY = 0;
            if (elapsed < (long)((Integer)StyleCombatClientConfig.HUD_COMBO_SHAKE.get()).intValue()) {
                double waveX = Math.sin((double)elapsed / 50.0) * 2.0;
                double waveY = Math.cos((double)elapsed / 60.0) * 1.5;
                shakeX = (int)waveX;
                shakeY = (int)waveY;
            }
            String comboText = "Combo: x" + combo;
            guiGraphics.m_280056_(mc.f_91062_, comboText, x + 8 + shakeX, barY + 12 + shakeY, -5592321, false);
        }
    }
}

